/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.http.netty.server;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.transport.HttpUriMapper;
import org.apache.cxf.transport.http.netty.server.NettyHttpContextHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpHandler;
import org.apache.cxf.transport.http.netty.server.NettyHttpServletPipelineFactory;
import org.apache.cxf.transport.http.netty.server.ServerEngine;
import org.apache.cxf.transport.http.netty.server.ThreadingParameters;

public class NettyHttpServerEngine
implements ServerEngine {
    private static final Logger LOG = LogUtils.getL7dLogger(NettyHttpServerEngine.class);
    private int port;
    private String host;
    private String protocol = "http";
    private volatile Channel serverChannel;
    private NettyHttpServletPipelineFactory servletPipeline;
    private Map<String, NettyHttpContextHandler> handlerMap = new ConcurrentHashMap<String, NettyHttpContextHandler>();
    private TLSServerParameters tlsServerParameters;
    private ThreadingParameters threadingParameters = new ThreadingParameters();
    private List<String> registedPaths = new CopyOnWriteArrayList<String>();
    private int readIdleTime = 60;
    private int writeIdleTime = 30;
    private int maxChunkContentSize = 0x100000;
    private boolean sessionSupport;
    private EventLoopGroup bossGroup = new NioEventLoopGroup();
    private EventLoopGroup workerGroup = new NioEventLoopGroup();

    public NettyHttpServerEngine() {
    }

    public NettyHttpServerEngine(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    @PostConstruct
    public void finalizeConfig() {
    }

    public void setTlsServerParameters(TLSServerParameters params) {
        this.tlsServerParameters = params;
    }

    public TLSServerParameters getTlsServerParameters() {
        return this.tlsServerParameters;
    }

    public void setThreadingParameters(ThreadingParameters params) {
        this.threadingParameters = params;
    }

    public ThreadingParameters getThreadingParameters() {
        return this.threadingParameters;
    }

    protected Channel startServer() {
        ServerBootstrap bootstrap = new ServerBootstrap();
        ((ServerBootstrap)bootstrap.group(this.bossGroup, this.workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_REUSEADDR, (Object)true);
        this.servletPipeline = new NettyHttpServletPipelineFactory(this.tlsServerParameters, this.sessionSupport, this.threadingParameters.getThreadPoolSize(), this.maxChunkContentSize, this.handlerMap, this);
        this.servletPipeline.start();
        bootstrap.childHandler((ChannelHandler)this.servletPipeline);
        InetSocketAddress address = null;
        address = this.host == null ? new InetSocketAddress(this.port) : new InetSocketAddress(this.host, this.port);
        try {
            return bootstrap.bind((SocketAddress)address).sync().channel();
        }
        catch (InterruptedException ex) {
            return null;
        }
    }

    protected void checkRegistedContext(URL url) {
        String path = url.getPath();
        for (String registedPath : this.registedPaths) {
            if (!path.equals(registedPath)) continue;
            throw new Fault(new Message("ADD_HANDLER_CONTEXT_IS_USED_MSG", LOG, new Object[]{url, registedPath}));
        }
    }

    @Override
    public void addServant(URL url, NettyHttpHandler handler) {
        this.checkRegistedContext(url);
        if (this.serverChannel == null) {
            this.serverChannel = this.startServer();
        }
        handler.setName(url.getPath());
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler == null) {
            contextHandler = new NettyHttpContextHandler(contextName);
            this.handlerMap.put(contextName, contextHandler);
        }
        contextHandler.addNettyHttpHandler(handler);
        this.registedPaths.add(url.getPath());
    }

    @Override
    public void removeServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler != null) {
            contextHandler.removeNettyHttpHandler(url.getPath());
            if (contextHandler.isEmpty()) {
                this.handlerMap.remove(contextName);
            }
        }
        this.registedPaths.remove(url.getPath());
    }

    @Override
    public NettyHttpHandler getServant(URL url) {
        String contextName = HttpUriMapper.getContextName((String)url.getPath());
        NettyHttpContextHandler contextHandler = this.handlerMap.get(contextName);
        if (contextHandler != null) {
            return contextHandler.getNettyHttpHandler(url.getPath());
        }
        return null;
    }

    public void shutdown() {
        this.handlerMap.clear();
        this.registedPaths.clear();
        if (this.servletPipeline != null) {
            this.servletPipeline.shutdown();
        }
        if (this.serverChannel != null) {
            this.serverChannel.close();
        }
        this.bossGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    public int getReadIdleTime() {
        return this.readIdleTime;
    }

    public void setReadIdleTime(int readIdleTime) {
        this.readIdleTime = readIdleTime;
    }

    public int getWriteIdleTime() {
        return this.writeIdleTime;
    }

    public void setWriteIdleTime(int writeIdleTime) {
        this.writeIdleTime = writeIdleTime;
    }

    public boolean isSessionSupport() {
        return this.sessionSupport;
    }

    public void setSessionSupport(boolean session) {
        this.sessionSupport = session;
    }

    public int getMaxChunkContentSize() {
        return this.maxChunkContentSize;
    }

    public void setMaxChunkContentSize(int maxChunkContentSize) {
        this.maxChunkContentSize = maxChunkContentSize;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getHost() {
        return this.host;
    }
}

