/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.enums;

import org.apache.dolphinscheduler.common.enums.ExecutionStatus;

public enum TaskStateType {
    WAITTING,
    RUNNING,
    FINISH,
    FAILED,
    SUCCESS;


    public static int[] convert2ExecutStatusIntArray(TaskStateType taskStateType) {
        switch (taskStateType) {
            case SUCCESS: {
                return new int[]{ExecutionStatus.SUCCESS.ordinal()};
            }
            case FAILED: {
                return new int[]{ExecutionStatus.FAILURE.ordinal(), ExecutionStatus.NEED_FAULT_TOLERANCE.ordinal()};
            }
            case FINISH: {
                return new int[]{ExecutionStatus.PAUSE.ordinal(), ExecutionStatus.STOP.ordinal()};
            }
            case RUNNING: {
                return new int[]{ExecutionStatus.SUBMITTED_SUCCESS.ordinal(), ExecutionStatus.RUNNING_EXEUTION.ordinal(), ExecutionStatus.READY_PAUSE.ordinal(), ExecutionStatus.READY_STOP.ordinal()};
            }
            case WAITTING: {
                return new int[]{ExecutionStatus.SUBMITTED_SUCCESS.ordinal()};
            }
        }
        return null;
    }
}

