/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.shell;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractShell {
    private static final Logger logger = LoggerFactory.getLogger(AbstractShell.class);
    protected long timeOutInterval = 0L;
    private AtomicBoolean timedOut;
    private long interval;
    private long lastTime;
    private Map<String, String> environment;
    private File dir;
    private Process process;
    private int exitCode;
    private volatile AtomicBoolean completed;

    public AbstractShell() {
        this(0L);
    }

    public AbstractShell(long interval) {
        this.interval = interval;
        this.lastTime = interval < 0L ? 0L : -interval;
    }

    protected void setEnvironment(Map<String, String> env) {
        this.environment = env;
    }

    protected void setWorkingDirectory(File dir) {
        this.dir = dir;
    }

    protected void run() throws IOException {
        if (this.lastTime + this.interval > System.currentTimeMillis()) {
            return;
        }
        this.exitCode = 0;
        this.runCommand();
    }

    private void runCommand() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.getExecString());
        Timer timeOutTimer = null;
        ShellTimeoutTimerTask timeoutTimerTask = null;
        this.timedOut = new AtomicBoolean(false);
        this.completed = new AtomicBoolean(false);
        if (this.environment != null) {
            builder.environment().putAll(this.environment);
        }
        if (this.dir != null) {
            builder.directory(this.dir);
        }
        this.process = builder.start();
        ProcessContainer.putProcess(this.process);
        if (this.timeOutInterval > 0L) {
            timeOutTimer = new Timer();
            timeoutTimerTask = new ShellTimeoutTimerTask(this);
            timeOutTimer.schedule((TimerTask)timeoutTimerTask, this.timeOutInterval);
        }
        final BufferedReader errReader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
        BufferedReader inReader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
        final StringBuilder errMsg = new StringBuilder();
        Thread errThread = new Thread(){

            @Override
            public void run() {
                try {
                    String line = errReader.readLine();
                    while (line != null && !this.isInterrupted()) {
                        errMsg.append(line);
                        errMsg.append(System.getProperty("line.separator"));
                        line = errReader.readLine();
                    }
                }
                catch (IOException ioe) {
                    logger.warn("Error reading the error stream", (Throwable)ioe);
                }
            }
        };
        try {
            errThread.start();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            this.parseExecResult(inReader);
            this.exitCode = this.process.waitFor();
            try {
                errThread.join();
            }
            catch (InterruptedException ie) {
                logger.warn("Interrupted while reading the error stream", (Throwable)ie);
            }
            this.completed.set(true);
            if (this.exitCode != 0) {
                throw new ExitCodeException(this.exitCode, errMsg.toString());
            }
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.toString());
        }
        finally {
            if (timeOutTimer != null && !this.timedOut.get()) {
                timeOutTimer.cancel();
            }
            try {
                inReader.close();
            }
            catch (IOException ioe) {
                logger.warn("Error while closing the input stream", (Throwable)ioe);
            }
            if (!this.completed.get()) {
                errThread.interrupt();
            }
            try {
                errReader.close();
            }
            catch (IOException ioe) {
                logger.warn("Error while closing the error stream", (Throwable)ioe);
            }
            ProcessContainer.removeProcess(this.process);
            this.process.destroy();
            this.lastTime = System.currentTimeMillis();
        }
    }

    protected abstract String[] getExecString();

    protected abstract void parseExecResult(BufferedReader var1) throws IOException;

    public Process getProcess() {
        return this.process;
    }

    public int getExitCode() {
        return this.exitCode;
    }

    private void setTimedOut() {
        this.timedOut.set(true);
    }

    public static class ProcessContainer
    extends ConcurrentHashMap<Integer, Process> {
        private static final ProcessContainer container = new ProcessContainer();

        private ProcessContainer() {
        }

        public static final ProcessContainer getInstance() {
            return container;
        }

        public static void putProcess(Process process) {
            ProcessContainer.getInstance().put(process.hashCode(), process);
        }

        public static int processSize() {
            return ProcessContainer.getInstance().size();
        }

        public static void removeProcess(Process process) {
            ProcessContainer.getInstance().remove(process.hashCode());
        }

        public static void destroyAllProcess() {
            Set set = ProcessContainer.getInstance().entrySet();
            for (Map.Entry entry : set) {
                try {
                    ((Process)entry.getValue()).destroy();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            logger.info("close " + set.size() + " executing process tasks");
        }
    }

    public static class ExitCodeException
    extends IOException {
        int exitCode;

        public ExitCodeException(int exitCode, String message) {
            super(message);
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }

    private static class ShellTimeoutTimerTask
    extends TimerTask {
        private AbstractShell shell;

        public ShellTimeoutTimerTask(AbstractShell shell) {
            this.shell = shell;
        }

        @Override
        public void run() {
            block2: {
                Process p = this.shell.getProcess();
                try {
                    p.exitValue();
                }
                catch (Exception e) {
                    if (p == null || this.shell.completed.get()) break block2;
                    this.shell.setTimedOut();
                    p.destroy();
                }
            }
        }
    }
}

