/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.thread;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.PrintWriter;
import java.lang.management.ThreadInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.dolphinscheduler.common.thread.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolExecutors {
    private static final Logger logger = LoggerFactory.getLogger(ThreadPoolExecutors.class);
    private static Executor executor;
    private static volatile ThreadPoolExecutors threadPoolExecutors;

    private ThreadPoolExecutors() {
    }

    public static ThreadPoolExecutors getInstance() {
        return ThreadPoolExecutors.getInstance("thread_pool", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolExecutors getInstance(String name, int maxThreads) {
        if (null != threadPoolExecutors) return threadPoolExecutors;
        Class<ThreadPoolExecutors> clazz = ThreadPoolExecutors.class;
        synchronized (ThreadPoolExecutors.class) {
            if (null == threadPoolExecutors) {
                threadPoolExecutors = new ThreadPoolExecutors();
            }
            if (null != executor) return threadPoolExecutors;
            executor = new Executor(null == name ? "thread_pool" : name, maxThreads == 0 ? Runtime.getRuntime().availableProcessors() * 3 : maxThreads);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return threadPoolExecutors;
        }
    }

    public void execute(Runnable event) {
        Executor executor = this.getExecutor();
        if (executor == null) {
            logger.error("Cannot execute [" + event + "] because the executor is missing.");
        } else {
            executor.execute(event);
        }
    }

    public Future<?> submit(Runnable event) {
        Executor executor = this.getExecutor();
        if (executor != null) {
            return executor.submit(event);
        }
        logger.error("Cannot submit [" + event + "] because the executor is missing.");
        return null;
    }

    public Future<?> submit(Callable<?> task) {
        Executor executor = this.getExecutor();
        if (executor != null) {
            return executor.submit(task);
        }
        logger.error("Cannot submit [" + task + "] because the executor is missing.");
        return null;
    }

    public void printStatus() {
        Executor executor = this.getExecutor();
        executor.getStatus().dumpInfo();
    }

    private Executor getExecutor() {
        return executor;
    }

    public void shutdown() {
        List<Runnable> wasRunning;
        if (executor != null && !(wasRunning = ThreadPoolExecutors.executor.threadPoolExecutor.shutdownNow()).isEmpty()) {
            logger.info(executor + " had " + wasRunning + " on shutdown");
        }
    }

    public static class RunningEventStatus {
        final ThreadInfo threadInfo;
        final Runnable event;

        public RunningEventStatus(Thread t, Runnable event) {
            this.threadInfo = ThreadUtils.getThreadInfo(t);
            this.event = event;
        }
    }

    public static class ExecutorStatus {
        final Executor executor;
        final List<Runnable> queuedEvents;
        final List<RunningEventStatus> running;

        ExecutorStatus(Executor executor, List<Runnable> queuedEvents, List<RunningEventStatus> running) {
            this.executor = executor;
            this.queuedEvents = queuedEvents;
            this.running = running;
        }

        public void dumpInfo() {
            PrintWriter out = new PrintWriter(System.out);
            out.write("Status for executor: " + this.executor + "\n");
            out.write("=======================================\n");
            out.write(this.queuedEvents.size() + " events queued, " + this.running.size() + " running\n");
            if (!this.queuedEvents.isEmpty()) {
                out.write("Queued:\n");
                for (Runnable e : this.queuedEvents) {
                    out.write("  " + e + "\n");
                }
                out.write("\n");
            }
            if (!this.running.isEmpty()) {
                out.write("Running:\n");
                for (RunningEventStatus stat : this.running) {
                    out.write("  Running on thread '" + stat.threadInfo.getThreadName() + "': " + stat.event + "\n");
                    out.write(ThreadUtils.formatThreadInfo(stat.threadInfo, "  "));
                    out.write("\n");
                }
            }
            out.flush();
        }
    }

    static class TrackingThreadPoolExecutor
    extends ThreadPoolExecutor {
        private ConcurrentMap<Thread, Runnable> running = Maps.newConcurrentMap();

        public TrackingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            super.afterExecute(r, t);
            this.running.remove(Thread.currentThread());
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Runnable oldPut = this.running.put(t, r);
            assert (oldPut == null) : "inconsistency for thread " + t;
            super.beforeExecute(t, r);
        }

        public ConcurrentMap<Thread, Runnable> getRunningTasks() {
            return this.running;
        }
    }

    private static class Executor {
        final long keepAliveTimeInMillis = 1000L;
        final TrackingThreadPoolExecutor threadPoolExecutor;
        final BlockingQueue<Runnable> q = new LinkedBlockingQueue<Runnable>();
        private final String name;
        private static final AtomicLong seqids = new AtomicLong(0L);
        private final long id = seqids.incrementAndGet();

        protected Executor(String name, int maxThreads) {
            this.name = name;
            this.threadPoolExecutor = new TrackingThreadPoolExecutor(maxThreads, maxThreads, 1000L, TimeUnit.MILLISECONDS, this.q);
            ThreadFactoryBuilder tfb = new ThreadFactoryBuilder();
            tfb.setNameFormat(this.name + "-%d");
            this.threadPoolExecutor.setThreadFactory(tfb.build());
        }

        void execute(Runnable event) {
            this.threadPoolExecutor.execute(event);
        }

        Future<?> submit(Runnable event) {
            return this.threadPoolExecutor.submit(event);
        }

        Future<?> submit(Callable<?> event) {
            return this.threadPoolExecutor.submit(event);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "-" + this.id + "-" + this.name;
        }

        public ExecutorStatus getStatus() {
            ArrayList queuedEvents = Lists.newArrayList();
            for (Runnable r : this.q) {
                queuedEvents.add(r);
            }
            ArrayList running = Lists.newArrayList();
            for (Map.Entry e : this.threadPoolExecutor.getRunningTasks().entrySet()) {
                Runnable r = (Runnable)e.getValue();
                running.add(new RunningEventStatus((Thread)e.getKey(), r));
            }
            return new ExecutorStatus(this, queuedEvents, running);
        }
    }
}

