/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Bytes {
    private static final Logger logger = LoggerFactory.getLogger(Bytes.class);
    public static final String UTF8_ENCODING = "UTF-8";
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static byte[] toBytes(ByteBuffer bb) {
        int length = bb.limit();
        byte[] result = new byte[length];
        System.arraycopy(bb.array(), bb.arrayOffset(), result, 0, length);
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        return new String(b, off, len, StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(String s) {
        return s.getBytes(StandardCharsets.UTF_8);
    }

    public static byte[] toBytes(boolean b) {
        return new byte[]{b ? (byte)-1 : 0};
    }

    public static boolean toBoolean(byte[] b) {
        if (b.length != 1) {
            throw new IllegalArgumentException("Array has wrong size: " + b.length);
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0, 8);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (length != 8 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 8);
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)(bytes[i] & 0xFF);
        }
        return l;
    }

    private static IllegalArgumentException explainWrongLengthOrOffset(byte[] bytes, int offset, int length, int expectedLength) {
        String reason = length != expectedLength ? "Wrong length: " + length + ", expected " + expectedLength : "offset (" + offset + ") + length (" + length + ") exceed the capacity of the array: " + bytes.length;
        return new IllegalArgumentException(reason);
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes.length - offset < 8) {
            throw new IllegalArgumentException("Not enough room to put a long at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        return Float.intBitsToFloat(Bytes.toInt(bytes, offset, 4));
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        return Bytes.putInt(bytes, offset, Float.floatToRawIntBits(f));
    }

    public static byte[] toBytes(float f) {
        return Bytes.toBytes(Float.floatToRawIntBits(f));
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        return Double.longBitsToDouble(Bytes.toLong(bytes, offset, 8));
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        return Bytes.putLong(bytes, offset, Double.doubleToLongBits(d));
    }

    public static byte[] toBytes(double d) {
        return Bytes.toBytes(Double.doubleToRawLongBits(d));
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0, 4);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (length != 4 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 4);
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes.length - offset < 4) {
            throw new IllegalArgumentException("Not enough room to put an int at offset " + offset + " in a " + bytes.length + " byte array");
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0, 2);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (length != 2 || offset + length > bytes.length) {
            throw Bytes.explainWrongLengthOrOffset(bytes, offset, length, 2);
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static byte[] getBytes(ByteBuffer buf) {
        int savedPos = buf.position();
        byte[] newBytes = new byte[buf.remaining()];
        buf.get(newBytes);
        buf.position(savedPos);
        return newBytes;
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes.length - offset < 2) {
            throw new IllegalArgumentException("Not enough room to put a short at offset " + offset + " in a " + bytes.length + " byte array");
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result, 0, val.scale());
        Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, offset);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, offset + 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        offset = Bytes.putInt(result, offset, val.scale());
        return Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
    }

    public static byte[] add(byte[] a, byte[] b) {
        return Bytes.add(a, b, EMPTY_BYTE_ARRAY);
    }

    public static byte[] add(byte[] a, byte[] b, byte[] c) {
        byte[] result = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        System.arraycopy(c, 0, result, a.length + b.length, c.length);
        return result;
    }

    public static byte[] head(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, 0, result, 0, length);
        return result;
    }

    public static byte[] tail(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, a.length - length, result, 0, length);
        return result;
    }

    public static byte[] padHead(byte[] a, int length) {
        byte[] padding = Bytes.getPadding(length);
        return Bytes.add(padding, a);
    }

    private static byte[] getPadding(int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return padding;
    }

    public static byte[] padTail(byte[] a, int length) {
        byte[] padding = Bytes.getPadding(length);
        return Bytes.add(a, padding);
    }

    public static int hashCode(byte[] bytes, int offset, int length) {
        int hash = 1;
        for (int i = offset; i < offset + length; ++i) {
            hash = 31 * hash + bytes[i];
        }
        return hash;
    }

    public static byte[][] toByteArrays(String[] t) {
        byte[][] result = new byte[t.length][];
        for (int i = 0; i < t.length; ++i) {
            result[i] = Bytes.toBytes(t[i]);
        }
        return result;
    }

    public static byte[][] toByteArrays(String column) {
        return Bytes.toByteArrays(Bytes.toBytes(column));
    }

    public static byte[][] toByteArrays(byte[] column) {
        byte[][] result = new byte[][]{column};
        return result;
    }
}

