/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.util.Date;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;

public class ResInfo {
    private double cpuUsage;
    private double memoryUsage;
    private double loadAverage;

    public ResInfo() {
    }

    public ResInfo(double cpuUsage, double memoryUsage) {
        this.cpuUsage = cpuUsage;
        this.memoryUsage = memoryUsage;
    }

    public ResInfo(double cpuUsage, double memoryUsage, double loadAverage) {
        this(cpuUsage, memoryUsage);
        this.loadAverage = loadAverage;
    }

    public double getCpuUsage() {
        return this.cpuUsage;
    }

    public void setCpuUsage(double cpuUsage) {
        this.cpuUsage = cpuUsage;
    }

    public double getMemoryUsage() {
        return this.memoryUsage;
    }

    public void setMemoryUsage(double memoryUsage) {
        this.memoryUsage = memoryUsage;
    }

    public double getLoadAverage() {
        return this.loadAverage;
    }

    public void setLoadAverage(double loadAverage) {
        this.loadAverage = loadAverage;
    }

    public static String getResInfoJson(double cpuUsage, double memoryUsage, double loadAverage) {
        ResInfo resInfo = new ResInfo(cpuUsage, memoryUsage, loadAverage);
        return JSONUtils.toJson(resInfo);
    }

    public static String getHeartBeatInfo(Date now) {
        return ResInfo.buildHeartbeatForZKInfo(OSUtils.getHost(), OSUtils.getProcessID(), OSUtils.cpuUsage(), OSUtils.memoryUsage(), OSUtils.loadAverage(), DateUtils.dateToString(now), DateUtils.dateToString(now));
    }

    public static String buildHeartbeatForZKInfo(String host, int port, double cpuUsage, double memoryUsage, double loadAverage, String createTime, String lastHeartbeatTime) {
        return host + "," + port + "," + cpuUsage + "," + memoryUsage + "," + loadAverage + "," + createTime + "," + lastHeartbeatTime;
    }

    public static Server parseHeartbeatForZKInfo(String heartBeatInfo) {
        Server masterServer = null;
        String[] masterArray = heartBeatInfo.split(",");
        if (masterArray == null || masterArray.length != 7) {
            return masterServer;
        }
        masterServer = new Server();
        masterServer.setHost(masterArray[0]);
        masterServer.setPort(Integer.parseInt(masterArray[1]));
        masterServer.setResInfo(ResInfo.getResInfoJson(Double.parseDouble(masterArray[2]), Double.parseDouble(masterArray[3]), Double.parseDouble(masterArray[4])));
        masterServer.setCreateTime(DateUtils.stringToDate(masterArray[5]));
        masterServer.setLastHeartbeatTime(DateUtils.stringToDate(masterArray[6]));
        return masterServer;
    }
}

