/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.utils;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptRunner {
    public static final Logger logger = LoggerFactory.getLogger(ScriptRunner.class);
    private static final String DEFAULT_DELIMITER = ";";
    private Connection connection;
    private boolean stopOnError;
    private boolean autoCommit;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    public void runScript(Reader reader) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader, String dbName) throws IOException, SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader, dbName);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (IOException e) {
            throw e;
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e, e);
        }
    }

    private void runScript(Connection conn, Reader reader) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    logger.info(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (trimmedLine.startsWith("delimiter")) {
                    String newDelimiter = trimmedLine.split(" ")[1];
                    this.setDelimiter(newDelimiter, this.fullLineDelimiter);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    boolean hasResults = false;
                    logger.info("sql:" + command.toString());
                    if (this.stopOnError) {
                        hasResults = statement.execute(command.toString());
                    } else {
                        try {
                            statement.execute(command.toString());
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            throw e;
                        }
                    }
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 0; i < cols; ++i) {
                            String name = md.getColumnLabel(i);
                            logger.info(name + "\t");
                        }
                        logger.info("");
                        while (rs.next()) {
                            for (i = 0; i < cols; ++i) {
                                String value = rs.getString(i);
                                logger.info(value + "\t");
                            }
                            logger.info("");
                        }
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (SQLException e) {
            logger.error("Error executing: " + command.toString());
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            logger.error("Error executing: " + command.toString());
            throw e;
        }
    }

    private void runScript(Connection conn, Reader reader, String dbName) throws IOException, SQLException {
        StringBuffer command = null;
        String sql = "";
        String appKey = dbName.substring(dbName.lastIndexOf("_") + 1, dbName.length());
        try {
            LineNumberReader lineReader = new LineNumberReader(reader);
            String line = null;
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    logger.info(trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (trimmedLine.startsWith("delimiter")) {
                    String newDelimiter = trimmedLine.split(" ")[1];
                    this.setDelimiter(newDelimiter, this.fullLineDelimiter);
                    continue;
                }
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line.substring(0, line.lastIndexOf(this.getDelimiter())));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    sql = command.toString().replaceAll("\\{\\{APPDB\\}\\}", dbName);
                    boolean hasResults = false;
                    logger.info("sql : " + sql);
                    if (this.stopOnError) {
                        hasResults = statement.execute(sql);
                    } else {
                        try {
                            statement.execute(sql);
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                            throw e;
                        }
                    }
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 0; i < cols; ++i) {
                            String name = md.getColumnLabel(i);
                            logger.info(name + "\t");
                        }
                        logger.info("");
                        while (rs.next()) {
                            for (i = 0; i < cols; ++i) {
                                String value = rs.getString(i);
                                logger.info(value + "\t");
                            }
                            logger.info("");
                        }
                    }
                    command = null;
                    try {
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
        }
        catch (SQLException e) {
            logger.error("Error executing: " + sql);
            throw e;
        }
        catch (IOException e) {
            e.fillInStackTrace();
            logger.error("Error executing: " + sql);
            throw e;
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }
}

