/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.zk;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.imps.CuratorFrameworkState;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.dolphinscheduler.common.IStoppable;
import org.apache.dolphinscheduler.common.enums.ZKNodeType;
import org.apache.dolphinscheduler.common.model.Server;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.OSUtils;
import org.apache.dolphinscheduler.common.utils.ResInfo;
import org.apache.dolphinscheduler.common.zk.ZookeeperCachedOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractZKClient
extends ZookeeperCachedOperator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractZKClient.class);
    protected IStoppable stoppable = null;

    public void heartBeatForZk(String znode, String serverType) {
        try {
            if (this.zkClient.getState() == CuratorFrameworkState.STOPPED || this.checkIsDeadServer(znode, serverType)) {
                this.stoppable.stop("i was judged to death, release resources and stop myself");
                return;
            }
            String resInfoStr = super.get(znode);
            String[] splits = resInfoStr.split(",");
            if (splits.length != 7) {
                return;
            }
            String str = splits[0] + "," + splits[1] + "," + OSUtils.cpuUsage() + "," + OSUtils.memoryUsage() + "," + OSUtils.loadAverage() + "," + splits[5] + "," + DateUtils.dateToString(new Date());
            this.zkClient.setData().forPath(znode, str.getBytes());
        }
        catch (Exception e) {
            logger.error("heartbeat for zk failed : " + e.getMessage(), (Throwable)e);
            this.stoppable.stop("heartbeat for zk exception, release resources and stop myself");
        }
    }

    protected boolean checkIsDeadServer(String zNode, String serverType) throws Exception {
        String[] zNodesPath = zNode.split("\\/");
        String ipSeqNo = zNodesPath[zNodesPath.length - 1];
        String type = serverType.equals("master") ? "master" : "worker";
        String deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + ipSeqNo;
        return !this.isExisted(zNode) || this.isExisted(deadServerPath);
    }

    public void removeDeadServerByHost(String host, String serverType) throws Exception {
        List<String> deadServers = super.getChildrenKeys(this.getDeadZNodeParentPath());
        for (String serverPath : deadServers) {
            if (!serverPath.startsWith(serverType + "_" + host)) continue;
            String server = this.getDeadZNodeParentPath() + "/" + serverPath;
            super.remove(server);
            logger.info("{} server {} deleted from zk dead server path success", (Object)serverType, (Object)host);
        }
    }

    private String createZNodePath(ZKNodeType zkNodeType, String host) throws Exception {
        String heartbeatZKInfo = ResInfo.getHeartBeatInfo(new Date());
        String registerPath = this.getZNodeParentPath(zkNodeType) + "/" + host;
        super.persistEphemeral(registerPath, heartbeatZKInfo);
        logger.info("register {} node {} success", (Object)zkNodeType.toString(), (Object)registerPath);
        return registerPath;
    }

    public String registerServer(ZKNodeType zkNodeType) throws Exception {
        String registerPath = null;
        String host = OSUtils.getHost();
        if (this.checkZKNodeExists(host, zkNodeType)) {
            logger.error("register failure , {} server already started on host : {}", (Object)zkNodeType.toString(), (Object)host);
            return registerPath;
        }
        registerPath = this.createZNodePath(zkNodeType, host);
        this.handleDeadServer(registerPath, zkNodeType, "delete");
        return registerPath;
    }

    public void handleDeadServer(String zNode, ZKNodeType zkNodeType, String opType) throws Exception {
        String deadServerPath;
        String type;
        String host = this.getHostByEventDataPath(zNode);
        String string = type = zkNodeType == ZKNodeType.MASTER ? "master" : "worker";
        if (opType.equals("delete")) {
            this.removeDeadServerByHost(host, type);
        } else if (opType.equals("add") && !super.isExisted(deadServerPath = this.getDeadZNodeParentPath() + "/" + type + "_" + host)) {
            super.persist(deadServerPath, type + "_" + host);
            logger.info("{} server dead , and {} added to zk dead server path success", (Object)zkNodeType.toString(), (Object)zNode);
        }
    }

    public void setStoppable(IStoppable serverStoppable) {
        this.stoppable = serverStoppable;
    }

    public int getActiveMasterNum() {
        List<Object> childrenList = new ArrayList();
        try {
            if (super.isExisted(this.getZNodeParentPath(ZKNodeType.MASTER))) {
                childrenList = super.getChildrenKeys(this.getZNodeParentPath(ZKNodeType.MASTER));
            }
        }
        catch (Exception e) {
            logger.error("getActiveMasterNum error", (Throwable)e);
        }
        return childrenList.size();
    }

    public String getZookeeperQuorum() {
        return this.getZookeeperConfig().getServerList();
    }

    public List<Server> getServersList(ZKNodeType zkNodeType) {
        Map<String, String> masterMap = this.getServerMaps(zkNodeType);
        String parentPath = this.getZNodeParentPath(zkNodeType);
        ArrayList<Server> masterServers = new ArrayList<Server>();
        int i = 0;
        for (Map.Entry<String, String> entry : masterMap.entrySet()) {
            Server masterServer = ResInfo.parseHeartbeatForZKInfo(entry.getValue());
            masterServer.setZkDirectory(parentPath + "/" + entry.getKey());
            masterServer.setId(i);
            ++i;
            masterServers.add(masterServer);
        }
        return masterServers;
    }

    public Map<String, String> getServerMaps(ZKNodeType zkNodeType) {
        HashMap<String, String> masterMap = new HashMap<String, String>();
        try {
            String path = this.getZNodeParentPath(zkNodeType);
            List<String> serverList = super.getChildrenKeys(path);
            for (String server : serverList) {
                masterMap.putIfAbsent(server, super.get(path + "/" + server));
            }
        }
        catch (Exception e) {
            logger.error("get server list failed : " + e.getMessage(), (Throwable)e);
        }
        return masterMap;
    }

    public boolean checkZKNodeExists(String host, ZKNodeType zkNodeType) {
        String path = this.getZNodeParentPath(zkNodeType);
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("check zk node exists error, host:{}, zk node type:{}", (Object)host, (Object)zkNodeType.toString());
            return false;
        }
        Map<String, String> serverMaps = this.getServerMaps(zkNodeType);
        for (String hostKey : serverMaps.keySet()) {
            if (!hostKey.startsWith(host)) continue;
            return true;
        }
        return false;
    }

    protected String getWorkerZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/workers";
    }

    protected String getMasterZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/masters";
    }

    public String getMasterLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/masters";
    }

    public String getWorkerLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/workers";
    }

    public String getZNodeParentPath(ZKNodeType zkNodeType) {
        String path = "";
        switch (zkNodeType) {
            case MASTER: {
                return this.getMasterZNodeParentPath();
            }
            case WORKER: {
                return this.getWorkerZNodeParentPath();
            }
            case DEAD_SERVER: {
                return this.getDeadZNodeParentPath();
            }
        }
        return path;
    }

    protected String getDeadZNodeParentPath() {
        return this.getZookeeperConfig().getDsRoot() + "/dead-servers";
    }

    public String getMasterStartUpLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/startup-masters";
    }

    public String getMasterFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/masters";
    }

    public String getWorkerFailoverLockPath() {
        return this.getZookeeperConfig().getDsRoot() + "/lock/failover/workers";
    }

    public static void releaseMutex(InterProcessMutex mutex) {
        if (mutex != null) {
            try {
                mutex.release();
            }
            catch (Exception e) {
                if (e.getMessage().equals("instance must be started before calling this method")) {
                    logger.warn("lock release");
                }
                logger.error("lock release failed : " + e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void initSystemZNode() {
        try {
            this.persist(this.getMasterZNodeParentPath(), "");
            this.persist(this.getWorkerZNodeParentPath(), "");
            this.persist(this.getDeadZNodeParentPath(), "");
            logger.info("initialize server nodes success.");
        }
        catch (Exception e) {
            logger.error("init system znode failed : " + e.getMessage(), (Throwable)e);
        }
    }

    protected boolean checkServerSelfDead(String serverHost, ZKNodeType zkNodeType) {
        if (serverHost.equals(OSUtils.getHost())) {
            logger.error("{} server({}) of myself dead , stopping...", (Object)zkNodeType.toString(), (Object)serverHost);
            this.stoppable.stop(String.format(" %s server %s of myself dead , stopping...", zkNodeType.toString(), serverHost));
            return true;
        }
        return false;
    }

    protected String getHostByEventDataPath(String path) {
        if (StringUtils.isEmpty((CharSequence)path)) {
            logger.error("empty path!");
            return "";
        }
        String[] pathArray = path.split("/");
        if (pathArray.length < 1) {
            logger.error("parse ip error: {}", (Object)path);
            return "";
        }
        return pathArray[pathArray.length - 1];
    }

    public InterProcessMutex acquireZkLock(CuratorFramework zkClient, String zNodeLockPath) throws Exception {
        InterProcessMutex mutex = new InterProcessMutex(zkClient, zNodeLockPath);
        mutex.acquire();
        return mutex;
    }

    public String toString() {
        return "AbstractZKClient{zkClient=" + this.zkClient + ", deadServerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.DEAD_SERVER) + '\'' + ", masterZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.MASTER) + '\'' + ", workerZNodeParentPath='" + this.getZNodeParentPath(ZKNodeType.WORKER) + '\'' + ", stoppable=" + this.stoppable + '}';
    }
}

