/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.common.zk;

import java.nio.charset.StandardCharsets;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.dolphinscheduler.common.zk.ZookeeperOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ZookeeperCachedOperator
extends ZookeeperOperator {
    private final Logger logger = LoggerFactory.getLogger(ZookeeperCachedOperator.class);
    TreeCache treeCache;

    @Override
    protected void registerListener() {
        this.treeCache = new TreeCache(this.zkClient, this.getZookeeperConfig().getDsRoot());
        this.logger.info("add listener to zk path: {}", (Object)this.getZookeeperConfig().getDsRoot());
        try {
            this.treeCache.start();
        }
        catch (Exception e) {
            this.logger.error("add listener to zk path: {} failed", (Object)this.getZookeeperConfig().getDsRoot());
            throw new RuntimeException(e);
        }
        this.treeCache.getListenable().addListener((client, event) -> {
            String path;
            String string = path = null == event.getData() ? "" : event.getData().getPath();
            if (path.isEmpty()) {
                return;
            }
            this.dataChanged(client, event, path);
        });
    }

    protected void dataChanged(CuratorFramework client, TreeCacheEvent event, String path) {
    }

    public String getFromCache(String cachePath, String key) {
        ChildData resultInCache = this.treeCache.getCurrentData(key);
        if (null != resultInCache) {
            return null == resultInCache.getData() ? null : new String(resultInCache.getData(), StandardCharsets.UTF_8);
        }
        return null;
    }

    public TreeCache getTreeCache(String cachePath) {
        return this.treeCache;
    }

    @Override
    public void close() {
        this.treeCache.close();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        super.close();
    }
}

