/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FileUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkDeployMode;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.plugin.task.flink.ProgramType;

public class FlinkArgsUtils {
    private static final String LOCAL_DEPLOY_MODE = "local";
    private static final String FLINK_VERSION_BEFORE_1_10 = "<1.10";
    private static final String FLINK_VERSION_AFTER_OR_EQUALS_1_12 = ">=1.12";
    private static final String FLINK_VERSION_AFTER_OR_EQUALS_1_13 = ">=1.13";
    public static final FlinkDeployMode DEFAULT_DEPLOY_MODE = FlinkDeployMode.CLUSTER;

    private FlinkArgsUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static List<String> buildRunCommandLine(TaskExecutionContext taskExecutionContext, FlinkParameters param) {
        switch (param.getProgramType()) {
            case SQL: {
                return FlinkArgsUtils.buildRunCommandLineForSql(taskExecutionContext, param);
            }
        }
        return FlinkArgsUtils.buildRunCommandLineForOthers(taskExecutionContext, param);
    }

    public static List<String> buildCancelCommandLine(TaskExecutionContext taskExecutionContext) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("flink");
        args.add("cancel");
        args.add(taskExecutionContext.getAppIds());
        return args;
    }

    public static List<String> buildSavePointCommandLine(TaskExecutionContext taskExecutionContext) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("flink");
        args.add("savepoint");
        args.add(taskExecutionContext.getAppIds());
        return args;
    }

    private static List<String> buildRunCommandLineForSql(TaskExecutionContext taskExecutionContext, FlinkParameters flinkParameters) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("sql-client.sh");
        String initScriptFilePath = FileUtils.getInitScriptFilePath(taskExecutionContext);
        args.add("-i");
        args.add(initScriptFilePath);
        String scriptFilePath = FileUtils.getScriptFilePath(taskExecutionContext);
        args.add("-f");
        args.add(scriptFilePath);
        String others = flinkParameters.getOthers();
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        return args;
    }

    public static List<String> buildInitOptionsForSql(FlinkParameters flinkParameters) {
        ArrayList<String> initOptions = new ArrayList<String>();
        FlinkDeployMode deployMode = Optional.ofNullable(flinkParameters.getDeployMode()).orElse(FlinkDeployMode.CLUSTER);
        if (FlinkDeployMode.LOCAL == deployMode) {
            initOptions.add(String.format("set execution.target=%s", LOCAL_DEPLOY_MODE));
        } else {
            String queue;
            String others;
            String taskManagerMemory;
            String jobManagerMemory;
            String appName;
            initOptions.add(String.format("set execution.target=%s", "yarn-per-job"));
            int slot = flinkParameters.getSlot();
            if (slot > 0) {
                initOptions.add(String.format("set taskmanager.numberOfTaskSlots=%d", slot));
            }
            if (StringUtils.isNotEmpty((CharSequence)(appName = flinkParameters.getAppName()))) {
                initOptions.add(String.format("set yarn.application.name=%s", ArgsUtils.escape((String)appName)));
            }
            if (StringUtils.isNotEmpty((CharSequence)(jobManagerMemory = flinkParameters.getJobManagerMemory()))) {
                initOptions.add(String.format("set jobmanager.memory.process.size=%s", jobManagerMemory));
            }
            if (StringUtils.isNotEmpty((CharSequence)(taskManagerMemory = flinkParameters.getTaskManagerMemory()))) {
                initOptions.add(String.format("set taskmanager.memory.process.size=%s", taskManagerMemory));
            }
            if ((StringUtils.isEmpty((CharSequence)(others = flinkParameters.getOthers())) || !others.contains("-yqu")) && StringUtils.isNotEmpty((CharSequence)(queue = flinkParameters.getQueue()))) {
                initOptions.add(String.format("set yarn.application.queue=%s", queue));
            }
        }
        int parallelism = flinkParameters.getParallelism();
        if (parallelism > 0) {
            initOptions.add(String.format("set parallelism.default=%d", parallelism));
        }
        return initOptions;
    }

    private static List<String> buildRunCommandLineForOthers(TaskExecutionContext taskExecutionContext, FlinkParameters flinkParameters) {
        String mainArgs;
        ResourceInfo mainJar;
        ArrayList<String> args = new ArrayList<String>();
        args.add("flink");
        FlinkDeployMode deployMode = Optional.ofNullable(flinkParameters.getDeployMode()).orElse(DEFAULT_DEPLOY_MODE);
        String flinkVersion = flinkParameters.getFlinkVersion();
        switch (deployMode) {
            case CLUSTER: {
                if (FLINK_VERSION_AFTER_OR_EQUALS_1_12.equals(flinkVersion) || FLINK_VERSION_AFTER_OR_EQUALS_1_13.equals(flinkVersion)) {
                    args.add("run");
                    args.add("-t");
                    args.add("yarn-per-job");
                    break;
                }
                args.add("run");
                args.add("-m");
                args.add("yarn-cluster");
                break;
            }
            case APPLICATION: {
                args.add("run-application");
                args.add("-t");
                args.add("yarn-application");
                break;
            }
            case LOCAL: {
                args.add("run");
            }
        }
        String others = flinkParameters.getOthers();
        switch (deployMode) {
            case CLUSTER: 
            case APPLICATION: {
                String queue;
                String taskManagerMemory;
                String jobManagerMemory;
                int taskManager;
                String appName;
                int slot = flinkParameters.getSlot();
                if (slot > 0) {
                    args.add("-ys");
                    args.add(String.format("%d", slot));
                }
                if (StringUtils.isNotEmpty((CharSequence)(appName = flinkParameters.getAppName()))) {
                    args.add("-ynm");
                    args.add(ArgsUtils.escape((String)appName));
                }
                if ((flinkVersion == null || FLINK_VERSION_BEFORE_1_10.equals(flinkVersion)) && (taskManager = flinkParameters.getTaskManager()) > 0) {
                    args.add("-yn");
                    args.add(String.format("%d", taskManager));
                }
                if (StringUtils.isNotEmpty((CharSequence)(jobManagerMemory = flinkParameters.getJobManagerMemory()))) {
                    args.add("-yjm");
                    args.add(jobManagerMemory);
                }
                if (StringUtils.isNotEmpty((CharSequence)(taskManagerMemory = flinkParameters.getTaskManagerMemory()))) {
                    args.add("-ytm");
                    args.add(taskManagerMemory);
                }
                if (!StringUtils.isEmpty((CharSequence)others) && others.contains("-yqu") || !StringUtils.isNotEmpty((CharSequence)(queue = flinkParameters.getQueue()))) break;
                args.add("-yqu");
                args.add(queue);
                break;
            }
        }
        int parallelism = flinkParameters.getParallelism();
        if (parallelism > 0) {
            args.add("-p");
            args.add(String.format("%d", parallelism));
        }
        args.add("-sae");
        if (StringUtils.isNotEmpty((CharSequence)others)) {
            args.add(others);
        }
        ProgramType programType = flinkParameters.getProgramType();
        String mainClass = flinkParameters.getMainClass();
        if (programType != null && programType != ProgramType.PYTHON && StringUtils.isNotEmpty((CharSequence)mainClass)) {
            args.add("-c");
            args.add(flinkParameters.getMainClass());
        }
        if ((mainJar = flinkParameters.getMainJar()) != null) {
            if (ProgramType.PYTHON == programType) {
                args.add("-py");
            }
            args.add(mainJar.getRes());
        }
        if (StringUtils.isNotEmpty((CharSequence)(mainArgs = flinkParameters.getMainArgs()))) {
            Map paramsMap = taskExecutionContext.getPrepareParamsMap();
            args.add(ParameterUtils.convertParameterPlaceholders((String)mainArgs, (Map)ParamUtils.convert((Map)paramsMap)));
        }
        return args;
    }
}

