/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.flink;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FileUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkArgsUtils;
import org.apache.dolphinscheduler.plugin.task.flink.FlinkParameters;
import org.apache.dolphinscheduler.plugin.task.flink.ProgramType;

public class FlinkTask
extends AbstractYarnTask {
    private FlinkParameters flinkParameters;
    private TaskExecutionContext taskExecutionContext;
    protected static final Pattern FLINK_APPLICATION_REGEX = Pattern.compile("JobID \\w+");

    public FlinkTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("flink task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.flinkParameters = (FlinkParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), FlinkParameters.class));
        if (this.flinkParameters == null || !this.flinkParameters.checkParameters()) {
            throw new RuntimeException("flink task params is not valid");
        }
        this.flinkParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        FileUtils.generateScriptFile(this.taskExecutionContext, this.flinkParameters);
    }

    protected String buildCommand() {
        List<String> args = FlinkArgsUtils.buildRunCommandLine(this.taskExecutionContext, this.flinkParameters);
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)this.taskExecutionContext.getDefinedParams());
        this.logger.info("flink task command : {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        if (this.flinkParameters.getProgramType() == ProgramType.SQL) {
            this.logger.info("The current flink job type is SQL, will no need to set main jar");
            return;
        }
        ResourceInfo mainJar = this.flinkParameters.getMainJar();
        String resourceName = this.getResourceNameOfMainJar(mainJar);
        mainJar.setRes(resourceName);
        this.flinkParameters.setMainJar(mainJar);
        this.logger.info("Success set flink jar: {}", (Object)resourceName);
    }

    public AbstractParameters getParameters() {
        return this.flinkParameters;
    }

    protected String findAppId(String line) {
        Matcher matcher = FLINK_APPLICATION_REGEX.matcher(line);
        if (matcher.find()) {
            String str = matcher.group();
            return str.substring(6);
        }
        return null;
    }
}

