/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.mr;

import java.util.ArrayList;
import java.util.Map;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.plugin.task.api.AbstractYarnTask;
import org.apache.dolphinscheduler.plugin.task.api.TaskExecutionContext;
import org.apache.dolphinscheduler.plugin.task.api.model.ResourceInfo;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParamUtils;
import org.apache.dolphinscheduler.plugin.task.api.parser.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceArgsUtils;
import org.apache.dolphinscheduler.plugin.task.mr.MapReduceParameters;
import org.apache.dolphinscheduler.plugin.task.mr.ProgramType;

public class MapReduceTask
extends AbstractYarnTask {
    private static final String MAPREDUCE_COMMAND = "hadoop";
    private MapReduceParameters mapreduceParameters;
    private TaskExecutionContext taskExecutionContext;

    public MapReduceTask(TaskExecutionContext taskExecutionContext) {
        super(taskExecutionContext);
        this.taskExecutionContext = taskExecutionContext;
    }

    public void init() {
        this.logger.info("mapreduce task params {}", (Object)this.taskExecutionContext.getTaskParams());
        this.mapreduceParameters = (MapReduceParameters)((Object)JSONUtils.parseObject((String)this.taskExecutionContext.getTaskParams(), MapReduceParameters.class));
        if (this.mapreduceParameters == null || !this.mapreduceParameters.checkParameters()) {
            throw new RuntimeException("mapreduce task params is not valid");
        }
        this.mapreduceParameters.setQueue(this.taskExecutionContext.getQueue());
        this.setMainJarName();
        Map paramsMap = this.taskExecutionContext.getPrepareParamsMap();
        String args = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getMainArgs(), (Map)ParamUtils.convert((Map)paramsMap));
        this.mapreduceParameters.setMainArgs(args);
        if (this.mapreduceParameters.getProgramType() != null && this.mapreduceParameters.getProgramType() == ProgramType.PYTHON) {
            String others = ParameterUtils.convertParameterPlaceholders((String)this.mapreduceParameters.getOthers(), (Map)ParamUtils.convert((Map)paramsMap));
            this.mapreduceParameters.setOthers(others);
        }
    }

    protected String buildCommand() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(MAPREDUCE_COMMAND);
        args.addAll(MapReduceArgsUtils.buildArgs(this.mapreduceParameters));
        String command = ParameterUtils.convertParameterPlaceholders((String)String.join((CharSequence)" ", args), (Map)this.taskExecutionContext.getDefinedParams());
        this.logger.info("mapreduce task command: {}", (Object)command);
        return command;
    }

    protected void setMainJarName() {
        ResourceInfo mainJar = this.mapreduceParameters.getMainJar();
        String resourceName = this.getResourceNameOfMainJar(mainJar);
        mainJar.setRes(resourceName);
        this.mapreduceParameters.setMainJar(mainJar);
    }

    public AbstractParameters getParameters() {
        return this.mapreduceParameters;
    }
}

