/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.plugin.task.sql;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SqlSplitter {
    private static final String LINE_SEPARATOR = "\n";

    private SqlSplitter() {
    }

    public static List<String> split(String sql, String segmentSeparator) {
        if (Strings.isNullOrEmpty((String)segmentSeparator)) {
            return Collections.singletonList(sql);
        }
        String[] lines = sql.split(LINE_SEPARATOR);
        ArrayList<String> segments = new ArrayList<String>();
        StringBuilder stmt = new StringBuilder();
        for (String line : lines) {
            if (line.trim().isEmpty() || line.startsWith("--")) continue;
            stmt.append(LINE_SEPARATOR).append(line);
            if (!line.trim().endsWith(segmentSeparator)) continue;
            segments.add(stmt.toString());
            stmt.setLength(0);
        }
        if (stmt.length() > 0) {
            segments.add(stmt.toString());
        }
        return segments;
    }
}

