/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.utils.CollectionUtils;

public class InputRowListPlusRawValues {
    @Nullable
    private final List<InputRow> inputRows;
    @Nullable
    private final List<Map<String, Object>> rawValues;
    @Nullable
    private final ParseException parseException;

    public static InputRowListPlusRawValues of(@Nullable InputRow inputRow, Map<String, Object> rawColumns) {
        return InputRowListPlusRawValues.of(inputRow == null ? null : Collections.singletonList(inputRow), rawColumns);
    }

    public static InputRowListPlusRawValues of(@Nullable List<InputRow> inputRows, Map<String, Object> rawColumns) {
        return new InputRowListPlusRawValues(inputRows, Collections.singletonList(Preconditions.checkNotNull(rawColumns, (Object)"rawColumns")), null);
    }

    public static InputRowListPlusRawValues of(@Nullable Map<String, Object> rawColumns, ParseException parseException) {
        return new InputRowListPlusRawValues(null, rawColumns == null ? null : Collections.singletonList(rawColumns), (ParseException)Preconditions.checkNotNull((Object)parseException, (Object)"parseException"));
    }

    public static InputRowListPlusRawValues ofList(@Nullable List<Map<String, Object>> rawColumnsList, ParseException parseException) {
        return InputRowListPlusRawValues.ofList(rawColumnsList, null, parseException);
    }

    public static InputRowListPlusRawValues ofList(@Nullable List<Map<String, Object>> rawColumnsList, @Nullable List<InputRow> inputRows) {
        return InputRowListPlusRawValues.ofList(rawColumnsList, inputRows, null);
    }

    public static InputRowListPlusRawValues ofList(@Nullable List<Map<String, Object>> rawColumnsList, @Nullable List<InputRow> inputRows, @Nullable ParseException parseException) {
        if (rawColumnsList != null && inputRows != null && rawColumnsList.size() != inputRows.size()) {
            throw new ParseException(null, "Size of rawColumnsList([%s]) does not correspond to size of inputRows([%s])", rawColumnsList, inputRows);
        }
        return new InputRowListPlusRawValues(inputRows, rawColumnsList, parseException);
    }

    private InputRowListPlusRawValues(@Nullable List<InputRow> inputRows, @Nullable List<Map<String, Object>> rawValues, @Nullable ParseException parseException) {
        this.inputRows = inputRows;
        this.rawValues = rawValues;
        this.parseException = parseException;
    }

    @Nullable
    public List<InputRow> getInputRows() {
        return this.inputRows;
    }

    @Nullable
    public Map<String, Object> getRawValues() {
        return CollectionUtils.isNullOrEmpty(this.rawValues) ? null : (Map)Iterables.getOnlyElement(this.rawValues);
    }

    public List<Map<String, Object>> getRawValuesList() {
        return this.rawValues;
    }

    @Nullable
    public ParseException getParseException() {
        return this.parseException;
    }
}

