/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.io.IOUtils;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.IntermediateRowParsingReader;
import org.apache.druid.data.input.impl.MapInputRowParser;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.JSONFlattenerMaker;
import org.apache.druid.java.util.common.parsers.JSONPathSpec;
import org.apache.druid.java.util.common.parsers.ObjectFlattener;
import org.apache.druid.java.util.common.parsers.ObjectFlatteners;
import org.apache.druid.java.util.common.parsers.ParseException;

public class JsonReader
extends IntermediateRowParsingReader<InputEntity> {
    private final ObjectFlattener<JsonNode> flattener;
    private final ObjectMapper mapper;
    private final InputEntity source;
    private final InputRowSchema inputRowSchema;
    private final JsonFactory jsonFactory;

    JsonReader(InputRowSchema inputRowSchema, InputEntity source, JSONPathSpec flattenSpec, ObjectMapper mapper, boolean keepNullColumns) {
        this.inputRowSchema = inputRowSchema;
        this.source = source;
        this.flattener = ObjectFlatteners.create(flattenSpec, new JSONFlattenerMaker(keepNullColumns, inputRowSchema.getDimensionsSpec().useSchemaDiscovery()));
        this.mapper = mapper;
        this.jsonFactory = new JsonFactory();
    }

    @Override
    protected CloseableIterator<InputEntity> intermediateRowIterator() {
        return CloseableIterators.withEmptyBaggage(Iterators.singletonIterator((Object)this.source));
    }

    @Override
    protected InputEntity source() {
        return this.source;
    }

    @Override
    protected String intermediateRowAsString(@Nullable InputEntity entity) {
        if (entity == null) {
            return "null";
        }
        try {
            return IOUtils.toString((InputStream)entity.open(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<InputRow> parseInputRows(InputEntity entity) throws IOException, ParseException {
        ArrayList<InputRow> inputRows = new ArrayList<InputRow>();
        try (JsonParser parser = this.jsonFactory.createParser(entity.open());){
            MappingIterator delegate = this.mapper.readValues(parser, JsonNode.class);
            while (delegate.hasNext()) {
                JsonNode row = (JsonNode)delegate.next();
                inputRows.add(MapInputRowParser.parse(this.inputRowSchema, this.flattener.flatten(row)));
            }
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof JsonParseException) {
                String rowAsString = IOUtils.toString((InputStream)entity.open(), (Charset)StandardCharsets.UTF_8);
                throw new ParseException(rowAsString, (Throwable)e, "Unable to parse row [%s]", rowAsString);
            }
            throw e;
        }
        if (inputRows.isEmpty()) {
            String rowAsString = IOUtils.toString((InputStream)entity.open(), (Charset)StandardCharsets.UTF_8);
            throw new ParseException(rowAsString, "Unable to parse [%s] as the intermediateRow resulted in empty input row", rowAsString);
        }
        return inputRows;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected List<Map<String, Object>> toMap(InputEntity entity) throws IOException {
        try (JsonParser parser = this.jsonFactory.createParser(entity.open());){
            MappingIterator delegate = this.mapper.readValues(parser, Map.class);
            ImmutableList immutableList = FluentIterable.from(() -> delegate).transform(map -> map).toList();
            return immutableList;
        }
        catch (RuntimeException e) {
            if (!(e.getCause() instanceof JsonParseException)) throw e;
            String rowAsString = IOUtils.toString((InputStream)entity.open(), (Charset)StandardCharsets.UTF_8);
            throw new ParseException(rowAsString, (Throwable)e, "Unable to parse row [%s]", rowAsString);
        }
    }
}

