/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.channel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.channel.ReadableNilFrameChannel;

@NotThreadSafe
public class ComposingReadableFrameChannel
implements ReadableFrameChannel {
    private final List<Supplier<ReadableFrameChannel>> channels;
    private ReadableFrameChannel currentChannel;
    private int currentIndex;

    public ComposingReadableFrameChannel(int partition, List<Supplier<ReadableFrameChannel>> channels, HashSet<Integer> validChannels) {
        Preconditions.checkNotNull(channels, (Object)"channels is null");
        if (validChannels == null) {
            this.channels = ImmutableList.of(() -> ReadableNilFrameChannel.INSTANCE);
        } else {
            Preconditions.checkState((validChannels.size() > 0 ? 1 : 0) != 0, (Object)("No channels found for partition " + partition));
            ImmutableList.Builder validChannelsBuilder = ImmutableList.builder();
            ArrayList<Integer> sortedChannelIds = new ArrayList<Integer>(validChannels);
            Collections.sort(sortedChannelIds);
            for (Integer channelId : sortedChannelIds) {
                validChannelsBuilder.add(channels.get(channelId));
            }
            this.channels = validChannelsBuilder.build();
        }
        this.currentIndex = 0;
        this.currentChannel = null;
    }

    @Override
    public boolean isFinished() {
        this.initCurrentChannel();
        if (!this.currentChannel.isFinished()) {
            return false;
        }
        this.currentChannel.close();
        this.currentChannel = null;
        if (this.isLastIndex()) {
            return true;
        }
        ++this.currentIndex;
        return this.isFinished();
    }

    @Override
    public boolean canRead() {
        this.initCurrentChannel();
        if (this.currentChannel.canRead()) {
            return true;
        }
        if (this.currentChannel.isFinished()) {
            this.currentChannel.close();
            this.currentChannel = null;
            if (this.isLastIndex()) {
                return false;
            }
            ++this.currentIndex;
            return this.canRead();
        }
        return false;
    }

    @Override
    public Frame read() {
        return this.currentChannel.read();
    }

    @Override
    public ListenableFuture<?> readabilityFuture() {
        this.initCurrentChannel();
        if (!this.currentChannel.isFinished()) {
            return this.currentChannel.readabilityFuture();
        }
        this.currentChannel.close();
        this.currentChannel = null;
        if (this.isLastIndex()) {
            return Futures.immediateFuture((Object)true);
        }
        ++this.currentIndex;
        return this.readabilityFuture();
    }

    @Override
    public void close() {
        if (this.currentChannel != null) {
            this.currentChannel.close();
        }
    }

    private boolean isLastIndex() {
        return this.currentIndex == this.channels.size() - 1;
    }

    private void initCurrentChannel() {
        if (this.currentChannel == null) {
            this.currentChannel = this.channels.get(this.currentIndex).get();
        }
    }
}

