/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.field;

public class TransformUtils {
    public static long transformFromDouble(double n) {
        long bits = Double.doubleToLongBits(n);
        long mask = (bits & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Long.reverseBytes(bits ^ mask);
    }

    public static double detransformToDouble(long bits) {
        long reversedBits = Long.reverseBytes(bits);
        long mask = ((reversedBits ^ Long.MIN_VALUE) & Long.MIN_VALUE) >> 11 | Long.MIN_VALUE;
        return Double.longBitsToDouble(reversedBits ^ mask);
    }

    public static long transformFromLong(long n) {
        return Long.reverseBytes(n ^ Long.MIN_VALUE);
    }

    public static long detransformToLong(long bits) {
        return Long.reverseBytes(bits) ^ Long.MIN_VALUE;
    }

    public static int transformFromFloat(float n) {
        int bits = Float.floatToIntBits(n);
        int mask = (bits & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Integer.reverseBytes(bits ^ mask);
    }

    public static float detransformToFloat(int bits) {
        int reversedBits = Integer.reverseBytes(bits);
        int mask = ((reversedBits ^ Integer.MIN_VALUE) & Integer.MIN_VALUE) >> 8 | Integer.MIN_VALUE;
        return Float.intBitsToFloat(reversedBits ^ mask);
    }
}

