/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.EnumSet;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.channel.ByteTracker;
import org.apache.druid.frame.file.FrameFileFooter;
import org.apache.druid.frame.file.FrameFileWriter;
import org.apache.druid.java.util.common.FileUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.IOE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.MappedByteBufferHandler;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.segment.ReferenceCountingCloseableObject;
import org.apache.druid.utils.CloseableUtils;

public class FrameFile
implements Closeable {
    private static final Logger log = new Logger(FrameFile.class);
    private final File file;
    private final long fileLength;
    private final FrameFileFooter frameFileFooter;
    private final int maxMmapSize;
    private final ReferenceCountingCloseableObject<Closeable> referenceCounter;
    private final Closeable referenceReleaser;
    private Memory buffer;
    private long bufferOffset;
    private Runnable bufferCloser;

    private FrameFile(File file, long fileLength, FrameFileFooter frameFileFooter, @Nullable Memory wholeFileMemory, int maxMmapSize, ReferenceCountingCloseableObject<Closeable> referenceCounter, Closeable referenceReleaser) {
        this.file = file;
        this.fileLength = fileLength;
        this.frameFileFooter = frameFileFooter;
        this.maxMmapSize = maxMmapSize;
        this.referenceCounter = referenceCounter;
        this.referenceReleaser = referenceReleaser;
        if (wholeFileMemory != null) {
            assert (wholeFileMemory.getCapacity() == fileLength);
            this.buffer = wholeFileMemory;
        }
    }

    public static FrameFile open(File file, @Nullable ByteTracker byteTracker, Flag ... flags) throws IOException {
        return FrameFile.open(file, Integer.MAX_VALUE, byteTracker, flags);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static FrameFile open(File file, int maxMmapSize, @Nullable ByteTracker byteTracker, Flag ... flags) throws IOException {
        EnumSet<Flag> flagSet;
        EnumSet<Flag> enumSet = flagSet = flags.length == 0 ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(Arrays.asList(flags));
        if (!file.exists()) {
            throw new FileNotFoundException(StringUtils.format("File[%s] not found", file));
        }
        MappedByteBufferHandler sharedMapCloser = null;
        try (RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");){
            Memory footerMemory;
            Memory wholeFileMemory;
            long fileLength = randomAccessFile.length();
            if (fileLength < (long)(FrameFileWriter.MAGIC.length + 16 + 1)) {
                throw new IOE("File[%s] is too short (size[%,d])", file, fileLength);
            }
            byte[] buf = new byte[16];
            Memory bufMemory = Memory.wrap((byte[])buf, (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            randomAccessFile.readFully(buf, 0, FrameFileWriter.MAGIC.length);
            if (!bufMemory.equalTo(0L, (Object)Memory.wrap((byte[])FrameFileWriter.MAGIC), 0L, (long)FrameFileWriter.MAGIC.length)) {
                throw new IOE("File[%s] is not a frame file", file);
            }
            randomAccessFile.seek(fileLength - 16L);
            randomAccessFile.readFully(buf, 0, 16);
            int footerLength = bufMemory.getInt(8L);
            if (footerLength < 0) {
                throw new ISE("Negative-size footer. Corrupt or truncated file[%s]?", file);
            }
            if ((long)footerLength > fileLength) {
                throw new ISE("Oversize footer. Corrupt or truncated file[%s]?", file);
            }
            if (fileLength <= (long)maxMmapSize) {
                MappedByteBufferHandler mapHandle;
                sharedMapCloser = mapHandle = FileUtils.map(randomAccessFile, 0L, fileLength);
                wholeFileMemory = Memory.wrap((ByteBuffer)mapHandle.get(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
                if (wholeFileMemory.getCapacity() != fileLength) {
                    throw new ISE("Memory map size does not match file size", new Object[0]);
                }
                footerMemory = wholeFileMemory.region(fileLength - (long)footerLength, (long)footerLength, ByteOrder.LITTLE_ENDIAN);
            } else {
                MappedByteBufferHandler footerMapHandle;
                sharedMapCloser = footerMapHandle = FileUtils.map(randomAccessFile, fileLength - (long)footerLength, (long)footerLength);
                wholeFileMemory = null;
                footerMemory = Memory.wrap((ByteBuffer)footerMapHandle.get(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
            }
            FrameFileFooter frameFileFooter = new FrameFileFooter(footerMemory, fileLength);
            Closer fileCloser = Closer.create();
            fileCloser.register(sharedMapCloser);
            if (flagSet.contains((Object)Flag.DELETE_ON_CLOSE)) {
                fileCloser.register(() -> {
                    if (!file.delete()) {
                        log.warn("Could not delete frame file[%s]", file);
                    }
                    if (byteTracker != null) {
                        byteTracker.release(fileLength - (long)footerLength - (long)FrameFileWriter.MAGIC.length);
                    }
                });
            }
            ReferenceCountingCloseableObject<Closeable> referenceCounter = new ReferenceCountingCloseableObject<Closeable>((Closeable)fileCloser){};
            FrameFile frameFile = new FrameFile(file, fileLength, frameFileFooter, wholeFileMemory, maxMmapSize, referenceCounter, referenceCounter);
            return frameFile;
        }
        catch (Throwable e) {
            if (!(e instanceof IOException)) throw CloseableUtils.closeAndWrapInCatch(e, sharedMapCloser);
            throw CloseableUtils.closeInCatch((IOException)e, sharedMapCloser);
        }
    }

    public int numFrames() {
        return this.frameFileFooter.getNumFrames();
    }

    public int numPartitions() {
        return this.frameFileFooter.getNumPartitions();
    }

    public int getPartitionStartFrame(int partition) {
        this.checkOpen();
        return this.frameFileFooter.getPartitionStartFrame(partition);
    }

    public Frame frame(int frameNumber) {
        this.checkOpen();
        if (frameNumber < 0 || frameNumber >= this.numFrames()) {
            throw new IAE("Frame [%,d] out of bounds", frameNumber);
        }
        long frameEnd = this.frameFileFooter.getFrameEndPosition(frameNumber);
        long frameStart = frameNumber == 0 ? (long)(FrameFileWriter.MAGIC.length + 1) : this.frameFileFooter.getFrameEndPosition(frameNumber - 1) + 1L;
        if (this.buffer == null || frameStart < this.bufferOffset || frameEnd > this.bufferOffset + this.buffer.getCapacity()) {
            this.remapBuffer(frameStart);
        }
        if (frameStart < this.bufferOffset || frameEnd > this.bufferOffset + this.buffer.getCapacity()) {
            throw new ISE("Frame [%,d] too large (max size = %,d bytes)", frameNumber, this.maxMmapSize);
        }
        return Frame.decompress(this.buffer, frameStart - this.bufferOffset, frameEnd - frameStart);
    }

    public FrameFile newReference() {
        Closeable releaser = this.referenceCounter.incrementReferenceAndDecrementOnceCloseable().orElseThrow(() -> new ISE("Frame file is closed", new Object[0]));
        return new FrameFile(this.file, this.fileLength, this.frameFileFooter, this.bufferOffset == 0L && this.bufferCloser == null ? this.buffer : null, this.maxMmapSize, this.referenceCounter, releaser);
    }

    public File file() {
        return this.file;
    }

    @Override
    public void close() throws IOException {
        CloseableUtils.closeAll(this::releaseBuffer, this.referenceReleaser);
    }

    private void checkOpen() {
        if (this.referenceCounter.isClosed()) {
            throw new ISE("Frame file is closed", new Object[0]);
        }
    }

    private void remapBuffer(long offset) {
        MappedByteBufferHandler mapHandle;
        this.releaseBuffer();
        if (offset >= this.fileLength) {
            throw new IAE("Offset [%,d] out of range for file length [%,d]", offset, this.fileLength);
        }
        try {
            mapHandle = FileUtils.map(this.file, offset, Math.min(this.fileLength - offset, (long)this.maxMmapSize));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.buffer = Memory.wrap((ByteBuffer)mapHandle.get(), (ByteOrder)ByteOrder.LITTLE_ENDIAN);
        this.bufferCloser = mapHandle::close;
        this.bufferOffset = offset;
    }

    private void releaseBuffer() {
        try {
            if (this.bufferCloser != null) {
                this.bufferCloser.run();
            }
        }
        finally {
            this.buffer = null;
            this.bufferCloser = null;
        }
    }

    public static enum Flag {
        DELETE_ON_CLOSE;

    }
}

