/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor;

import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectSortedMap;
import it.unimi.dsi.fastutil.ints.IntSortedSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.druid.frame.channel.ReadableFrameChannel;
import org.apache.druid.frame.processor.OutputChannel;

public class OutputChannels {
    private final List<OutputChannel> outputChannels;
    private final Int2ObjectSortedMap<List<OutputChannel>> partitionToChannelMap;

    private OutputChannels(List<OutputChannel> outputChannels) {
        this.outputChannels = outputChannels;
        this.partitionToChannelMap = new Int2ObjectRBTreeMap();
        for (OutputChannel outputChannel : outputChannels) {
            ((List)this.partitionToChannelMap.computeIfAbsent(outputChannel.getPartitionNumber(), ignored -> new ArrayList())).add(outputChannel);
        }
    }

    public static OutputChannels none() {
        return OutputChannels.wrap(Collections.emptyList());
    }

    public static OutputChannels wrap(List<OutputChannel> outputChannels) {
        return new OutputChannels(outputChannels);
    }

    public static OutputChannels wrapReadOnly(List<OutputChannel> outputChannels) {
        return new OutputChannels(outputChannels.stream().map(OutputChannel::readOnly).collect(Collectors.toList()));
    }

    public IntSortedSet getPartitionNumbers() {
        return this.partitionToChannelMap.keySet();
    }

    public List<OutputChannel> getAllChannels() {
        return this.outputChannels;
    }

    public List<ReadableFrameChannel> getAllReadableChannels() {
        return this.outputChannels.stream().map(OutputChannel::getReadableChannel).collect(Collectors.toList());
    }

    public List<OutputChannel> getChannelsForPartition(int partitionNumber) {
        List retVal = (List)this.partitionToChannelMap.get(partitionNumber);
        if (retVal != null) {
            return retVal;
        }
        return Collections.emptyList();
    }

    public OutputChannels readOnly() {
        return OutputChannels.wrapReadOnly(this.outputChannels);
    }

    public boolean areReadableChannelsReady() {
        for (OutputChannel outputChannel : this.outputChannels) {
            if (outputChannel.isReadableChannelReady()) continue;
            return false;
        }
        return true;
    }
}

