/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.processor.manager;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.apache.druid.frame.processor.FrameProcessor;
import org.apache.druid.frame.processor.manager.ProcessorAndCallback;
import org.apache.druid.frame.processor.manager.ProcessorManager;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Yielder;
import org.apache.druid.java.util.common.guava.Yielders;
import org.apache.druid.utils.CloseableUtils;

public class SequenceProcessorManager<T, P extends FrameProcessor<T>>
implements ProcessorManager<T, Long> {
    private final Sequence<P> sequence;
    private Yielder<P> yielder;
    private boolean done;
    private long numProcessors;

    SequenceProcessorManager(Sequence<P> sequence) {
        this.sequence = sequence;
    }

    @Override
    public ListenableFuture<Optional<ProcessorAndCallback<T>>> next() {
        FrameProcessor retVal;
        this.initializeYielderIfNeeded();
        if (this.done) {
            if (this.yielder == null) {
                throw new IllegalStateException();
            }
            throw new NoSuchElementException();
        }
        if (this.yielder.isDone()) {
            this.done = true;
            return Futures.immediateFuture(Optional.empty());
        }
        try {
            retVal = (FrameProcessor)Preconditions.checkNotNull(this.yielder.get(), (Object)"processor");
            this.yielder = this.yielder.next(null);
        }
        catch (Throwable e) {
            this.done = true;
            CloseableUtils.closeAndSuppressExceptions(this.yielder, e::addSuppressed);
            this.yielder = null;
            throw e;
        }
        return Futures.immediateFuture(Optional.of(new ProcessorAndCallback<Object>(retVal, r -> ++this.numProcessors)));
    }

    @Override
    public Long result() {
        return this.numProcessors;
    }

    @Override
    public void close() {
        this.done = true;
        if (this.yielder != null) {
            CloseableUtils.closeAndWrapExceptions(this.yielder);
            this.yielder = null;
        }
    }

    private void initializeYielderIfNeeded() {
        if (!this.done && this.yielder == null) {
            this.yielder = Yielders.each(this.sequence);
        }
    }
}

