/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.field.FieldReader;
import org.apache.druid.frame.field.FieldReaders;
import org.apache.druid.frame.key.FrameComparisonWidget;
import org.apache.druid.frame.key.FrameComparisonWidgetImpl;
import org.apache.druid.frame.key.KeyColumn;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaders;
import org.apache.druid.frame.segment.columnar.ColumnarFrameCursorFactory;
import org.apache.druid.frame.segment.row.RowFrameCursorFactory;
import org.apache.druid.frame.write.FrameWriterUtils;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;

public class FrameReader {
    private final RowSignature signature;
    private final List<FrameColumnReader> columnReaders;
    private final List<FieldReader> fieldReaders;

    private FrameReader(RowSignature signature, List<FrameColumnReader> columnReaders, List<FieldReader> fieldReaders) {
        this.signature = signature;
        this.columnReaders = columnReaders;
        this.fieldReaders = fieldReaders;
    }

    public static FrameReader create(RowSignature signature) {
        Set<String> disallowedFieldNames = FrameWriterUtils.findDisallowedFieldNames(signature);
        if (!disallowedFieldNames.isEmpty()) {
            throw new IAE("Disallowed field names: %s", disallowedFieldNames);
        }
        ArrayList<FrameColumnReader> columnReaders = new ArrayList<FrameColumnReader>(signature.size());
        ArrayList<FieldReader> fieldReaders = new ArrayList<FieldReader>(signature.size());
        for (int columnNumber = 0; columnNumber < signature.size(); ++columnNumber) {
            ColumnType columnType = (ColumnType)Preconditions.checkNotNull(signature.getColumnType(columnNumber).orElse(null), (String)"Type for column [%s]", (Object)signature.getColumnName(columnNumber));
            fieldReaders.add(FieldReaders.create(signature.getColumnName(columnNumber), columnType));
            columnReaders.add(FrameColumnReaders.create(signature.getColumnName(columnNumber), columnNumber, columnType));
        }
        return new FrameReader(signature, columnReaders, fieldReaders);
    }

    public RowSignature signature() {
        return this.signature;
    }

    @Nullable
    public ColumnCapabilities columnCapabilities(Frame frame, String columnName) {
        int columnNumber = this.signature.indexOf(columnName);
        if (columnNumber < 0) {
            return null;
        }
        switch (frame.type()) {
            case COLUMNAR: {
                return this.columnReaders.get(columnNumber).readColumn(frame).getCapabilities();
            }
        }
        return this.signature.getColumnCapabilities(columnName);
    }

    public CursorFactory makeCursorFactory(Frame frame) {
        switch (frame.type()) {
            case COLUMNAR: {
                return new ColumnarFrameCursorFactory(frame, this.signature, this.columnReaders);
            }
            case ROW_BASED: {
                return new RowFrameCursorFactory(frame, this, this.fieldReaders);
            }
        }
        throw DruidException.defensive("Unrecognized frame type [%s]", new Object[]{frame.type()});
    }

    public FrameComparisonWidget makeComparisonWidget(Frame frame, List<KeyColumn> keyColumns) {
        FrameWriterUtils.verifySortColumns(keyColumns, this.signature);
        return FrameComparisonWidgetImpl.create(frame, this.signature, keyColumns, this.fieldReaders.subList(0, keyColumns.size()));
    }
}

