/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.frame.read.columnar;

import com.google.common.math.LongMath;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.datasketches.memory.Memory;
import org.apache.druid.error.DruidException;
import org.apache.druid.frame.Frame;
import org.apache.druid.frame.read.columnar.ColumnPlus;
import org.apache.druid.frame.read.columnar.FrameColumnReader;
import org.apache.druid.frame.read.columnar.FrameColumnReaderUtils;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.column.ColumnAccessorBasedColumn;
import org.apache.druid.query.rowsandcols.column.accessor.ObjectColumnAccessorBase;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.ObjectColumnSelector;
import org.apache.druid.segment.column.BaseColumn;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.vector.ReadableVectorOffset;
import org.apache.druid.segment.vector.VectorObjectSelector;

public abstract class NumericArrayFrameColumnReader
implements FrameColumnReader {
    private final byte typeCode;
    private final ColumnType columnType;
    private final int columnNumber;

    public NumericArrayFrameColumnReader(byte typeCode, ColumnType columnType, int columnNumber) {
        this.typeCode = typeCode;
        this.columnType = columnType;
        this.columnNumber = columnNumber;
    }

    @Override
    public Column readRACColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        return new ColumnAccessorBasedColumn(this.column(frame, memory, this.columnType));
    }

    @Override
    public ColumnPlus readColumn(Frame frame) {
        Memory memory = frame.region(this.columnNumber);
        this.validate(memory);
        return new ColumnPlus(this.column(frame, memory, this.columnType), ColumnCapabilitiesImpl.createSimpleArrayColumnCapabilities(this.columnType), frame.numRows());
    }

    abstract NumericArrayFrameColumn column(Frame var1, Memory var2, ColumnType var3);

    private void validate(Memory region) {
        if (region.getCapacity() < 1L) {
            throw DruidException.defensive("Column[%s] is not big enough for a header", this.columnNumber);
        }
        byte actualTypeCode = region.getByte(0L);
        if (actualTypeCode != this.typeCode) {
            throw DruidException.defensive("Column[%s] does not have the correct type code; expected[%s], got[%s]", this.columnNumber, this.typeCode, actualTypeCode);
        }
    }

    private static long getStartOfCumulativeLengthSection() {
        return 1L;
    }

    private static long getStartOfRowNullityData(int numRows) {
        return NumericArrayFrameColumnReader.getStartOfCumulativeLengthSection() + (long)numRows * 4L;
    }

    private static long getStartOfRowData(Memory memory, int numRows) {
        long nullityDataOffset = 1L * (long)FrameColumnReaderUtils.getAdjustedCumulativeRowLength(memory, NumericArrayFrameColumnReader.getStartOfCumulativeLengthSection(), numRows - 1);
        return LongMath.checkedAdd((long)NumericArrayFrameColumnReader.getStartOfRowNullityData(numRows), (long)nullityDataOffset);
    }

    public static abstract class NumericArrayFrameColumn
    extends ObjectColumnAccessorBase
    implements BaseColumn {
        private final Frame frame;
        private final Memory memory;
        private final ColumnType columnType;
        private final long rowNullityDataOffset;
        private final long rowDataOffset;

        public NumericArrayFrameColumn(Frame frame, Memory memory, ColumnType columnType) {
            this.frame = frame;
            this.memory = memory;
            this.columnType = columnType;
            this.rowNullityDataOffset = NumericArrayFrameColumnReader.getStartOfRowNullityData(frame.numRows());
            this.rowDataOffset = NumericArrayFrameColumnReader.getStartOfRowData(memory, frame.numRows());
        }

        @Override
        public ColumnType getType() {
            return this.columnType;
        }

        @Override
        public int numRows() {
            return this.frame.numRows();
        }

        @Override
        protected Object getVal(int rowNum) {
            return this.getNumericArray(this.physicalRow(rowNum));
        }

        @Override
        protected Comparator<Object> getComparator() {
            return this.columnType.getNullableStrategy();
        }

        @Override
        public ColumnValueSelector<?> makeColumnValueSelector(final ReadableOffset offset) {
            return new ObjectColumnSelector<Object>(){
                private int cachedLogicalRow = -1;
                @Nullable
                private Object[] cachedValue = null;

                @Override
                public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
                }

                @Override
                @Nullable
                public Object getObject() {
                    this.compute();
                    return this.cachedValue;
                }

                @Override
                public Class<?> classOfObject() {
                    return Object[].class;
                }

                private void compute() {
                    int currentLogicalRow = offset.getOffset();
                    if (this.cachedLogicalRow == currentLogicalRow) {
                        return;
                    }
                    this.cachedValue = this.getNumericArray(this.physicalRow(currentLogicalRow));
                    this.cachedLogicalRow = currentLogicalRow;
                }
            };
        }

        @Override
        public VectorObjectSelector makeVectorObjectSelector(final ReadableVectorOffset offset) {
            return new VectorObjectSelector(){
                private final Object[] vector;
                private int id;
                {
                    this.vector = new Object[offset.getMaxVectorSize()];
                    this.id = -1;
                }

                @Override
                public Object[] getObjectVector() {
                    this.computeVector();
                    return this.vector;
                }

                @Override
                public int getMaxVectorSize() {
                    return offset.getMaxVectorSize();
                }

                @Override
                public int getCurrentVectorSize() {
                    return offset.getCurrentVectorSize();
                }

                private void computeVector() {
                    if (this.id == offset.getId()) {
                        return;
                    }
                    if (offset.isContiguous()) {
                        int start = offset.getStartOffset();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            this.vector[i] = this.getNumericArray(this.physicalRow(start + i));
                        }
                    } else {
                        int[] offsets = offset.getOffsets();
                        for (int i = 0; i < offset.getCurrentVectorSize(); ++i) {
                            this.vector[i] = this.getNumericArray(this.physicalRow(offsets[i]));
                        }
                        this.id = offset.getId();
                    }
                }
            };
        }

        @Override
        public void close() {
        }

        private int physicalRow(int logicalRow) {
            return this.frame.physicalRow(logicalRow);
        }

        @Nullable
        private Object[] getNumericArray(int physicalRow) {
            int rowLength;
            int cumulativeLength = FrameColumnReaderUtils.getCumulativeRowLength(this.memory, NumericArrayFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow);
            if (FrameColumnReaderUtils.isNullRow(cumulativeLength)) {
                return null;
            }
            if (physicalRow == 0) {
                rowLength = cumulativeLength;
            } else {
                int previousCumulativeLength = FrameColumnReaderUtils.adjustCumulativeRowLength(FrameColumnReaderUtils.getCumulativeRowLength(this.memory, NumericArrayFrameColumnReader.getStartOfCumulativeLengthSection(), physicalRow - 1));
                rowLength = cumulativeLength - previousCumulativeLength;
            }
            if (rowLength == 0) {
                return ObjectArrays.EMPTY_ARRAY;
            }
            Object[] row = new Object[rowLength];
            for (int i = 0; i < rowLength; ++i) {
                int cumulativeIndex = cumulativeLength - rowLength + i;
                row[i] = this.getElementNullity(cumulativeIndex) ? (Number)null : (Number)this.getElement(this.memory, this.rowDataOffset, cumulativeIndex);
            }
            return row;
        }

        private boolean getElementNullity(int cumulativeIndex) {
            byte b = this.memory.getByte(LongMath.checkedAdd((long)this.rowNullityDataOffset, (long)((long)cumulativeIndex * 1L)));
            if (b == 0) {
                return true;
            }
            assert (b == 1);
            return false;
        }

        abstract Number getElement(Memory var1, long var2, int var4);
    }
}

