/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.common.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;

public final class JacksonUtils {
    public static final TypeReference<Map<String, Object>> TYPE_REFERENCE_MAP_STRING_OBJECT = new TypeReference<Map<String, Object>>(){};
    public static final TypeReference<Map<String, String>> TYPE_REFERENCE_MAP_STRING_STRING = new TypeReference<Map<String, String>>(){};
    public static final TypeReference<Map<String, Boolean>> TYPE_REFERENCE_MAP_STRING_BOOLEAN = new TypeReference<Map<String, Boolean>>(){};

    private JacksonUtils() {
    }

    public static <T> T readValue(ObjectMapper mapper, byte[] bytes, Class<T> valueType) {
        try {
            return (T)mapper.readValue(bytes, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(ObjectMapper mapper, byte[] bytes, JavaType valueType) {
        try {
            return (T)mapper.readValue(bytes, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T readValue(ObjectMapper mapper, byte[] bytes, TypeReference<T> valueType) {
        try {
            return (T)mapper.readValue(bytes, valueType);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static JsonSerializer<Object> getSerializer(SerializerProvider serializerProvider, Class<?> clazz) throws JsonMappingException {
        return serializerProvider.findTypedValueSerializer(clazz, true, null);
    }

    public static void writeObjectUsingSerializerProvider(JsonGenerator jsonGenerator, SerializerProvider serializers, @Nullable Object o) throws IOException {
        if (o == null) {
            jsonGenerator.writeNull();
        } else {
            JsonSerializer<Object> serializer = JacksonUtils.getSerializer(serializers, o.getClass());
            serializer.serialize(o, jsonGenerator, serializers);
        }
    }

    @Nullable
    public static <T> T readObjectUsingDeserializationContext(JsonParser jp, DeserializationContext deserializationContext, Class<T> clazz) throws IOException {
        if (jp.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        return (T)deserializationContext.readValue(jp, clazz);
    }

    @Nullable
    public static Object readObjectUsingDeserializationContext(JsonParser jp, DeserializationContext deserializationContext, JavaType javaType) throws IOException {
        if (jp.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        return deserializationContext.readValue(jp, javaType);
    }

    public static byte[] toBytes(ObjectMapper jsonMapper, Object obj) {
        try {
            return jsonMapper.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new ISE("Failed to serialize " + obj.getClass().getSimpleName(), new Object[0]);
        }
    }
}

