/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.emitter.service;

import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.emitter.core.Event;
import org.apache.druid.java.util.emitter.core.EventMap;
import org.joda.time.DateTime;

public class AlertEvent
implements Event {
    private final ImmutableMap<String, String> serviceDimensions;
    private final Severity severity;
    private final String description;
    private final DateTime createdTime;
    private final Map<String, Object> dataMap;

    public AlertEvent(DateTime createdTime, ImmutableMap<String, String> serviceDimensions, Severity severity, String description, Map<String, Object> dataMap) {
        this.createdTime = createdTime;
        this.serviceDimensions = serviceDimensions;
        this.severity = severity;
        this.description = description;
        this.dataMap = dataMap;
    }

    public AlertEvent(DateTime createdTime, String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this(createdTime, (ImmutableMap<String, String>)ImmutableMap.of((Object)"service", (Object)service, (Object)"host", (Object)host), severity, description, dataMap);
    }

    public AlertEvent(String service, String host, Severity severity, String description, Map<String, Object> dataMap) {
        this(DateTimes.nowUtc(), service, host, severity, description, dataMap);
    }

    public AlertEvent(String service, String host, String description, Map<String, Object> dataMap) {
        this(DateTimes.nowUtc(), service, host, Severity.DEFAULT, description, dataMap);
    }

    public AlertEvent(String service, String host, String description) {
        this(DateTimes.nowUtc(), service, host, Severity.DEFAULT, description, (Map<String, Object>)ImmutableMap.of());
    }

    public DateTime getCreatedTime() {
        return this.createdTime;
    }

    @Override
    public String getFeed() {
        return "alerts";
    }

    public String getService() {
        return (String)this.serviceDimensions.get((Object)"service");
    }

    public String getHost() {
        return (String)this.serviceDimensions.get((Object)"host");
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, Object> getDataMap() {
        return Collections.unmodifiableMap(this.dataMap);
    }

    @Override
    @JsonValue
    public EventMap toMap() {
        return EventMap.builder().put("feed", this.getFeed()).put("timestamp", this.createdTime.toString()).putAll((Map<? extends String, ? extends Object>)this.serviceDimensions).put("severity", this.severity.toString()).put("description", this.description).put("data", this.dataMap).build();
    }

    public static enum Severity {
        ANOMALY{

            public String toString() {
                return "anomaly";
            }
        }
        ,
        COMPONENT_FAILURE{

            public String toString() {
                return "component-failure";
            }
        }
        ,
        SERVICE_FAILURE{

            public String toString() {
                return "service-failure";
            }
        }
        ,
        DEPRECATED{

            public String toString() {
                return "deprecated";
            }
        };

        public static final Severity DEFAULT;

        static {
            DEFAULT = COMPONENT_FAILURE;
        }
    }
}

