/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.math.expr.ConstantExpr;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;
import org.apache.druid.math.expr.vector.VectorProcessors;

class DoubleExpr
extends ConstantExpr<Double> {
    DoubleExpr(Double value) {
        super(ExpressionType.DOUBLE, Preconditions.checkNotNull((Object)value, (Object)"value"));
    }

    @Override
    protected ExprEval realEval() {
        return ExprEval.ofDouble((Number)this.value);
    }

    @Override
    public <T> ExprVectorProcessor<T> asVectorProcessor(Expr.VectorInputBindingInspector inspector) {
        return VectorProcessors.constant((Double)this.value, inspector.getMaxVectorSize());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DoubleExpr that = (DoubleExpr)o;
        return Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }
}

