/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr;

import com.google.common.base.Supplier;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.data.input.Row;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExpressionType;

public class InputBindings {
    private static final Expr.ObjectBinding NIL_BINDINGS = new Expr.ObjectBinding(){

        @Override
        @Nullable
        public Object get(String name) {
            return null;
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            return null;
        }
    };

    public static Expr.ObjectBinding nilBindings() {
        return NIL_BINDINGS;
    }

    public static Expr.ObjectBinding validateConstant(final Expr expr) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                throw new UOE("Expression " + expr.stringify() + " has non-constant inputs.", new Object[0]);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                throw new UOE("Expression " + expr.stringify() + " has non-constant inputs.", new Object[0]);
            }
        };
    }

    public static Expr.InputBindingInspector inspectorFromTypeMap(final Map<String, ExpressionType> types) {
        return new Expr.InputBindingInspector(){

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return (ExpressionType)types.get(name);
            }
        };
    }

    public static Expr.InputBindingInspector inspectorForColumn(final String column, final ExpressionType type) {
        return new Expr.InputBindingInspector(){

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                if (column.equals(name)) {
                    return type;
                }
                return null;
            }
        };
    }

    public static Expr.ObjectBinding forRow(final Row row) {
        return new BestEffortInputBindings(){

            @Override
            ExprEval compute(String name) {
                if ("__time".equals(name)) {
                    return ExprEval.ofLong(row.getTimestampFromEpoch());
                }
                return ExprEval.bestEffortOf(row.getRaw(name));
            }
        };
    }

    @Deprecated
    public static Expr.ObjectBinding forMap(final Map<String, ?> bindings) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                return bindings.get(name);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return ExprEval.bestEffortOf(bindings.get(name)).type();
            }
        };
    }

    public static Expr.ObjectBinding forMap(final Map<String, ?> bindings, Expr.InputBindingInspector inspector) {
        final Expr.InputBindingInspector inputBindingInspector = inspector;
        return new BestEffortInputBindings(){

            @Override
            @Nullable
            public Object get(String name) {
                if (inputBindingInspector.getType(name) != null) {
                    return bindings.get(name);
                }
                return super.get(name);
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                ExpressionType type = inputBindingInspector.getType(name);
                if (type != null) {
                    return type;
                }
                return super.getType(name);
            }

            @Override
            ExprEval compute(String name) {
                return ExprEval.bestEffortOf(bindings.get(name));
            }
        };
    }

    public static Expr.ObjectBinding forInputSupplier(final ExpressionType type, final Supplier<?> supplier) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                return supplier.get();
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                return type;
            }
        };
    }

    public static Expr.ObjectBinding forInputSupplier(final String supplierName, final ExpressionType type, final Supplier<?> supplier) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                if (Objects.equals(name, supplierName)) {
                    return supplier.get();
                }
                return null;
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                if (Objects.equals(name, supplierName)) {
                    return type;
                }
                return null;
            }
        };
    }

    public static <T> InputSupplier<T> inputSupplier(ExpressionType type, Supplier<T> supplier) {
        return new InputSupplier(type, supplier);
    }

    public static Expr.ObjectBinding forInputSuppliers(final Map<String, InputSupplier<?>> bindings) {
        return new Expr.ObjectBinding(){

            @Override
            @Nullable
            public Object get(String name) {
                InputSupplier binding = (InputSupplier)bindings.get(name);
                return binding == null ? null : binding.get();
            }

            @Override
            @Nullable
            public ExpressionType getType(String name) {
                InputSupplier binding = (InputSupplier)bindings.get(name);
                if (binding == null) {
                    return null;
                }
                return binding.getType();
            }
        };
    }

    public static abstract class BestEffortInputBindings
    implements Expr.ObjectBinding {
        private final Map<String, ExprEval> cachedBindings = new HashMap<String, ExprEval>();

        abstract ExprEval compute(String var1);

        @Override
        @Nullable
        public Object get(String name) {
            this.cachedBindings.computeIfAbsent(name, this::compute);
            return this.cachedBindings.get(name).value();
        }

        @Override
        @Nullable
        public ExpressionType getType(String name) {
            this.cachedBindings.computeIfAbsent(name, this::compute);
            return this.cachedBindings.get(name).type();
        }
    }

    public static class InputSupplier<T>
    implements Supplier<T> {
        private final ExpressionType type;
        private final Supplier<T> supplier;

        private InputSupplier(ExpressionType type, Supplier<T> supplier) {
            this.supplier = supplier;
            this.type = type;
        }

        public T get() {
            return (T)this.supplier.get();
        }

        public ExpressionType getType() {
            return this.type;
        }
    }
}

