/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.math.expr.vector;

import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.vector.ExprEvalDoubleVector;
import org.apache.druid.math.expr.vector.ExprEvalVector;
import org.apache.druid.math.expr.vector.ExprVectorProcessor;

public abstract class BivariateDoubleFunctionVectorValueProcessor<TLeftInput, TRightInput>
implements ExprVectorProcessor<double[]> {
    final ExprVectorProcessor<TLeftInput> left;
    final ExprVectorProcessor<TRightInput> right;
    final boolean[] outNulls;
    final double[] outValues;

    protected BivariateDoubleFunctionVectorValueProcessor(ExprVectorProcessor<TLeftInput> left, ExprVectorProcessor<TRightInput> right, int maxVectorSize) {
        this.left = left;
        this.right = right;
        this.outValues = new double[maxVectorSize];
        this.outNulls = new boolean[maxVectorSize];
    }

    @Override
    public final ExprEvalVector<double[]> evalVector(Expr.VectorInputBinding bindings) {
        ExprEvalVector<TLeftInput> lhs = this.left.evalVector(bindings);
        ExprEvalVector<TRightInput> rhs = this.right.evalVector(bindings);
        int currentSize = bindings.getCurrentVectorSize();
        boolean[] leftNulls = lhs.getNullVector();
        boolean[] rightNulls = rhs.getNullVector();
        boolean hasLeftNulls = leftNulls != null;
        boolean hasRightNulls = rightNulls != null;
        boolean hasNulls = hasLeftNulls || hasRightNulls;
        TLeftInput leftInput = lhs.values();
        TRightInput rightInput = rhs.values();
        if (hasNulls) {
            for (int i = 0; i < currentSize; ++i) {
                boolean bl = this.outNulls[i] = hasLeftNulls && leftNulls[i] || hasRightNulls && rightNulls[i];
                if (!this.outNulls[i]) {
                    this.processIndex(leftInput, rightInput, i);
                    continue;
                }
                this.outValues[i] = 0.0;
            }
        } else {
            for (int i = 0; i < currentSize; ++i) {
                this.processIndex(leftInput, rightInput, i);
                this.outNulls[i] = false;
            }
        }
        return this.asEval();
    }

    abstract void processIndex(TLeftInput var1, TRightInput var2, int var3);

    final ExprEvalVector<double[]> asEval() {
        return new ExprEvalDoubleVector(this.outValues, this.outNulls);
    }
}

