/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.druid.common.config.Configs;
import org.apache.druid.java.util.common.HumanReadableBytes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingBufferConfig;
import org.apache.druid.query.DruidProcessingIndexesConfig;
import org.apache.druid.segment.column.ColumnConfig;
import org.apache.druid.utils.JvmUtils;

public class DruidProcessingConfig
implements ColumnConfig {
    private static final Logger log = new Logger(DruidProcessingConfig.class);
    @JsonProperty
    private final String formatString;
    @JsonProperty
    private final int numThreads;
    @JsonProperty
    private final int numMergeBuffers;
    @JsonProperty
    private final boolean fifo;
    @JsonProperty
    private final String tmpDir;
    @JsonProperty
    private final DruidProcessingBufferConfig buffer;
    @JsonProperty
    private final DruidProcessingIndexesConfig indexes;
    private final AtomicReference<Integer> computedBufferSizeBytes = new AtomicReference();
    private final boolean numThreadsConfigured;
    private final boolean numMergeBuffersConfigured;

    @JsonCreator
    public DruidProcessingConfig(@JsonProperty(value="formatString") @Nullable String formatString, @JsonProperty(value="numThreads") @Nullable Integer numThreads, @JsonProperty(value="numMergeBuffers") @Nullable Integer numMergeBuffers, @JsonProperty(value="fifo") @Nullable Boolean fifo, @JsonProperty(value="tmpDir") @Nullable String tmpDir, @JsonProperty(value="buffer") DruidProcessingBufferConfig buffer, @JsonProperty(value="indexes") DruidProcessingIndexesConfig indexes) {
        this.formatString = Configs.valueOrDefault(formatString, "processing-%s");
        this.numThreads = Configs.valueOrDefault(numThreads, Math.max(JvmUtils.getRuntimeInfo().getAvailableProcessors() - 1, 1));
        this.numMergeBuffers = Configs.valueOrDefault(numMergeBuffers, Math.max(2, this.numThreads / 4));
        this.fifo = fifo == null || fifo != false;
        this.tmpDir = Configs.valueOrDefault(tmpDir, System.getProperty("java.io.tmpdir"));
        this.buffer = Configs.valueOrDefault(buffer, new DruidProcessingBufferConfig());
        this.indexes = Configs.valueOrDefault(indexes, new DruidProcessingIndexesConfig());
        this.numThreadsConfigured = numThreads != null;
        this.numMergeBuffersConfigured = numMergeBuffers != null;
        this.initializeBufferSize();
    }

    @VisibleForTesting
    public DruidProcessingConfig() {
        this(null, null, null, null, null, null, null);
    }

    private void initializeBufferSize() {
        long directSizeBytes;
        HumanReadableBytes sizeBytesConfigured = this.buffer.getBufferSize();
        if (!DruidProcessingBufferConfig.DEFAULT_PROCESSING_BUFFER_SIZE_BYTES.equals(sizeBytesConfigured)) {
            if (sizeBytesConfigured.getBytes() > Integer.MAX_VALUE) {
                throw new IAE("druid.processing.buffer.sizeBytes must be less than 2GiB", new Object[0]);
            }
            this.computedBufferSizeBytes.set(sizeBytesConfigured.getBytesInInt());
        }
        try {
            directSizeBytes = JvmUtils.getRuntimeInfo().getDirectMemorySizeBytes();
            log.info("Detected max direct memory size of [%,d] bytes", directSizeBytes);
        }
        catch (UnsupportedOperationException e) {
            directSizeBytes = Runtime.getRuntime().maxMemory() / 4L;
            log.info("Using up to [%,d] bytes of direct memory for computation buffers.", directSizeBytes);
        }
        int totalNumBuffers = this.numMergeBuffers + this.numThreads;
        int sizePerBuffer = (int)((double)directSizeBytes / (double)(totalNumBuffers + 1));
        int computedSizePerBuffer = Math.min(sizePerBuffer, 0x40000000);
        if (this.computedBufferSizeBytes.compareAndSet(null, computedSizePerBuffer)) {
            log.info("Auto sizing buffers to [%,d] bytes each for [%,d] processing and [%,d] merge buffers. If you run out of direct memory, you may need to set these parameters explicitly using the guidelines at https://druid.apache.org/docs/latest/operations/basic-cluster-tuning.html#processing-threads-buffers.", computedSizePerBuffer, this.numThreads, this.numMergeBuffers);
        }
    }

    public String getFormatString() {
        return this.formatString;
    }

    public int getNumThreads() {
        return this.numThreads;
    }

    public int getNumMergeBuffers() {
        return this.numMergeBuffers;
    }

    public boolean isFifo() {
        return this.fifo;
    }

    public String getTmpDir() {
        return this.tmpDir;
    }

    public int intermediateComputeSizeBytes() {
        return this.computedBufferSizeBytes.get();
    }

    public int poolCacheMaxCount() {
        return this.buffer.getPoolCacheMaxCount();
    }

    public int getNumInitalBuffersForIntermediatePool() {
        return this.buffer.getPoolCacheInitialCount();
    }

    @Override
    public double skipValueRangeIndexScale() {
        return this.indexes.getSkipValueRangeIndexScale();
    }

    public boolean isNumThreadsConfigured() {
        return this.numThreadsConfigured;
    }

    public boolean isNumMergeBuffersConfigured() {
        return this.numMergeBuffersConfigured;
    }
}

