/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.FilteredSegment;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.utils.JvmUtils;

public class FilteredDataSource
implements DataSource {
    private final DataSource base;
    private final DimFilter filter;

    @JsonProperty(value="base")
    public DataSource getBase() {
        return this.base;
    }

    @JsonProperty(value="filter")
    public DimFilter getFilter() {
        return this.filter;
    }

    private FilteredDataSource(DataSource base, @Nullable DimFilter filter) {
        this.base = base;
        this.filter = filter;
    }

    @JsonCreator
    public static FilteredDataSource create(@JsonProperty(value="base") DataSource base, @JsonProperty(value="filter") @Nullable DimFilter f) {
        return new FilteredDataSource(base, f);
    }

    @Override
    public Set<String> getTableNames() {
        return this.base.getTableNames();
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.of((Object)this.base);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != 1) {
            throw new IAE("Expected [1] child, got [%d]", children.size());
        }
        return new FilteredDataSource(children.get(0), this.filter);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.base.isGlobal();
    }

    @Override
    public boolean isConcrete() {
        return this.base.isConcrete();
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTimeAccumulator) {
        Function<SegmentReference, SegmentReference> segmentMapFn = this.base.createSegmentMapFunction(query, cpuTimeAccumulator);
        return JvmUtils.safeAccumulateThreadCpuTime(cpuTimeAccumulator, () -> baseSegment -> new FilteredSegment((SegmentReference)segmentMapFn.apply((SegmentReference)baseSegment), this.filter));
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return new FilteredDataSource(newSource, this.filter);
    }

    public String toString() {
        return "FilteredDataSource{base=" + this.base + ", filter='" + this.filter + '\'' + '}';
    }

    @Override
    public byte[] getCacheKey() {
        return new byte[0];
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        DataSource current = this.getBase();
        return current.getAnalysis();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilteredDataSource that = (FilteredDataSource)o;
        return Objects.equals(this.base, that.base) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.base, this.filter);
    }
}

