/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.Order;

public class OrderBy {
    private final String columnName;
    private final Order order;

    public static OrderBy ascending(String columnName) {
        return new OrderBy(columnName, Order.ASCENDING);
    }

    public static OrderBy descending(String columnName) {
        return new OrderBy(columnName, Order.DESCENDING);
    }

    @JsonCreator
    public OrderBy(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="order") Order order) {
        this.columnName = (String)Preconditions.checkNotNull((Object)columnName, (Object)"columnName");
        this.order = (Order)((Object)Preconditions.checkNotNull((Object)((Object)order), (Object)"order"));
        if (order == Order.NONE) {
            throw new IAE("Order required for column [%s]", columnName);
        }
    }

    @JsonProperty
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty
    public Order getOrder() {
        return this.order;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderBy that = (OrderBy)o;
        return Objects.equals(this.columnName, that.columnName) && this.order == that.order;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.columnName, this.order});
    }

    public String toString() {
        return StringUtils.format("%s %s", this.columnName, this.order == Order.ASCENDING ? "ASC" : "DESC");
    }
}

