/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.Query;
import org.apache.druid.query.TableDataSource;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.utils.CollectionUtils;

public class UnionDataSource
implements DataSource {
    @JsonProperty(value="dataSources")
    private final List<DataSource> dataSources;

    @JsonCreator
    public UnionDataSource(@JsonProperty(value="dataSources") List<DataSource> dataSources) {
        if (dataSources == null || dataSources.isEmpty()) {
            throw new ISE("'dataSources' must be non-null and non-empty for 'union'", new Object[0]);
        }
        this.dataSources = dataSources;
    }

    public List<DataSource> getDataSources() {
        return this.dataSources;
    }

    @Override
    public Set<String> getTableNames() {
        return this.dataSources.stream().map(input -> {
            if (!(input instanceof TableDataSource)) {
                throw DruidException.defensive("should be table", new Object[0]);
            }
            return (String)CollectionUtils.getOnlyElement(input.getTableNames(), xs -> DruidException.defensive("Expected only single table name in TableDataSource", new Object[0]));
        }).collect(Collectors.toSet());
    }

    public List<TableDataSource> getDataSourcesAsTableDataSources() {
        return this.dataSources.stream().map(input -> {
            if (!(input instanceof TableDataSource)) {
                throw DruidException.defensive("should be table", new Object[0]);
            }
            return (TableDataSource)input;
        }).collect(Collectors.toList());
    }

    @Override
    public List<DataSource> getChildren() {
        return ImmutableList.copyOf(this.dataSources);
    }

    @Override
    public DataSource withChildren(List<DataSource> children) {
        if (children.size() != this.dataSources.size()) {
            throw new IAE("Expected [%d] children, got [%d]", this.dataSources.size(), children.size());
        }
        return new UnionDataSource(children);
    }

    @Override
    public boolean isCacheable(boolean isBroker) {
        return false;
    }

    @Override
    public boolean isGlobal() {
        return this.dataSources.stream().allMatch(DataSource::isGlobal);
    }

    @Override
    public boolean isConcrete() {
        return this.dataSources.stream().allMatch(DataSource::isConcrete);
    }

    @Override
    public Function<SegmentReference, SegmentReference> createSegmentMapFunction(Query query, AtomicLong cpuTime) {
        return Function.identity();
    }

    @Override
    public DataSource withUpdatedDataSource(DataSource newSource) {
        return newSource;
    }

    @Override
    public byte[] getCacheKey() {
        return null;
    }

    @Override
    public DataSourceAnalysis getAnalysis() {
        return new DataSourceAnalysis(this, null, null, Collections.emptyList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UnionDataSource that = (UnionDataSource)o;
        return this.dataSources.equals(that.dataSources);
    }

    public int hashCode() {
        return this.dataSources.hashCode();
    }

    public String toString() {
        return "UnionDataSource{dataSources=" + this.dataSources + '}';
    }
}

