/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation;

import com.google.common.base.Preconditions;
import com.google.common.primitives.Ints;
import java.nio.ByteBuffer;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.SerializablePairLongDouble;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.SerializablePairLongLong;
import org.apache.druid.segment.serde.cell.StagedSerde;
import org.apache.druid.segment.serde.cell.StorableBuffer;

public abstract class AbstractSerializablePairLongObjectDeltaEncodedStagedSerde<T extends SerializablePair<Long, ?>>
implements StagedSerde<T> {
    final long minValue;
    final boolean useIntegerDelta;
    private final Class<?> pairClass;

    AbstractSerializablePairLongObjectDeltaEncodedStagedSerde(long minValue, boolean useIntegerDelta, Class<?> pairClass) {
        this.minValue = minValue;
        this.useIntegerDelta = useIntegerDelta;
        this.pairClass = pairClass;
    }

    @Override
    public StorableBuffer serializeDelayed(@Nullable T value) {
        if (value == null) {
            return StorableBuffer.EMPTY;
        }
        Object rhsObject = ((SerializablePair)value).getRhs();
        return new StorableBuffer((SerializablePair)value, rhsObject){
            final /* synthetic */ SerializablePair val$value;
            final /* synthetic */ Object val$rhsObject;
            {
                this.val$value = serializablePair;
                this.val$rhsObject = object;
            }

            @Override
            public void store(ByteBuffer byteBuffer) {
                Preconditions.checkNotNull((Object)this.val$value.lhs, (Object)String.format(Locale.ENGLISH, "Long in %s must be non-null", AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.getSimpleName()));
                long delta = (Long)this.val$value.lhs - AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.minValue;
                Preconditions.checkState((delta >= 0L || delta == (Long)this.val$value.lhs ? 1 : 0) != 0);
                if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.useIntegerDelta) {
                    byteBuffer.putInt(Ints.checkedCast((long)delta));
                } else {
                    byteBuffer.putLong(delta);
                }
                if (this.val$rhsObject != null) {
                    byteBuffer.put((byte)0);
                    if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongLong.class)) {
                        byteBuffer.putLong((Long)this.val$rhsObject);
                    } else if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongDouble.class)) {
                        byteBuffer.putDouble((Double)this.val$rhsObject);
                    } else if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongFloat.class)) {
                        byteBuffer.putFloat(((Float)this.val$rhsObject).floatValue());
                    }
                } else {
                    byteBuffer.put((byte)1);
                }
            }

            @Override
            public int getSerializedSize() {
                int rhsBytes = 0;
                if (this.val$rhsObject != null) {
                    if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongLong.class)) {
                        rhsBytes = 8;
                    } else if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongDouble.class)) {
                        rhsBytes = 8;
                    } else if (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.pairClass.isAssignableFrom(SerializablePairLongFloat.class)) {
                        rhsBytes = 4;
                    }
                }
                return (AbstractSerializablePairLongObjectDeltaEncodedStagedSerde.this.useIntegerDelta ? 4 : 8) + 1 + rhsBytes;
            }
        };
    }
}

