/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.cardinality.vector;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.hll.HyperLogLogCollector;
import org.apache.druid.query.aggregation.cardinality.types.StringCardinalityAggregatorColumnSelectorStrategy;
import org.apache.druid.query.aggregation.cardinality.vector.CardinalityVectorProcessor;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;

public class SingleValueStringCardinalityVectorProcessor
implements CardinalityVectorProcessor {
    private final SingleValueDimensionVectorSelector selector;

    public SingleValueStringCardinalityVectorProcessor(SingleValueDimensionVectorSelector selector) {
        this.selector = selector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int position, int startRow, int endRow) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            int[] vector = this.selector.getRowVector();
            buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
            buf.position(position);
            HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
            for (int i = startRow; i < endRow; ++i) {
                String value = this.selector.lookupName(vector[i]);
                StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, value);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void aggregate(ByteBuffer buf, int numRows, int[] positions, @Nullable int[] rows, int positionOffset) {
        int oldPosition = buf.position();
        int oldLimit = buf.limit();
        try {
            int[] vector = this.selector.getRowVector();
            for (int i = 0; i < numRows; ++i) {
                String s = this.selector.lookupName(vector[rows != null ? rows[i] : i]);
                if (!NullHandling.replaceWithDefault() && s == null) continue;
                int position = positions[i] + positionOffset;
                buf.limit(position + HyperLogLogCollector.getLatestNumBytesForDenseStorage());
                buf.position(position);
                HyperLogLogCollector collector = HyperLogLogCollector.makeCollector(buf);
                StringCardinalityAggregatorColumnSelectorStrategy.addStringToCollector(collector, s);
            }
        }
        finally {
            buf.limit(oldLimit);
            buf.position(oldPosition);
        }
    }
}

