/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.first;

import org.apache.druid.collections.SerializablePair;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.ColumnValueSelector;

public abstract class NumericFirstAggregator
implements Aggregator {
    private final boolean useDefault = NullHandling.replaceWithDefault();
    private final BaseLongColumnValueSelector timeSelector;
    private final boolean needsFoldCheck;
    final ColumnValueSelector valueSelector;
    long firstTime;
    boolean rhsNull;

    public NumericFirstAggregator(BaseLongColumnValueSelector timeSelector, ColumnValueSelector valueSelector, boolean needsFoldCheck) {
        this.timeSelector = timeSelector;
        this.valueSelector = valueSelector;
        this.needsFoldCheck = needsFoldCheck;
        this.firstTime = Long.MAX_VALUE;
        this.rhsNull = !this.useDefault;
    }

    abstract void setFirstValue();

    abstract void setFirstValue(Number var1);

    @Override
    public void aggregate() {
        Object object;
        if (this.needsFoldCheck && (object = this.valueSelector.getObject()) instanceof SerializablePair) {
            SerializablePair inPair = (SerializablePair)object;
            if ((Long)inPair.lhs < this.firstTime) {
                this.firstTime = (Long)inPair.lhs;
                if (inPair.rhs == null) {
                    this.rhsNull = true;
                } else {
                    this.rhsNull = false;
                    this.setFirstValue((Number)inPair.rhs);
                }
            }
            return;
        }
        if (this.timeSelector.isNull()) {
            return;
        }
        long time = this.timeSelector.getLong();
        if (time < this.firstTime) {
            this.firstTime = time;
            if (this.useDefault || !this.valueSelector.isNull()) {
                this.setFirstValue();
                this.rhsNull = false;
            } else {
                this.setFirstValue(0);
                this.rhsNull = true;
            }
        }
    }

    @Override
    public void close() {
    }
}

