/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.firstlast.last;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.collections.SerializablePair;
import org.apache.druid.query.aggregation.AggregateCombiner;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.SerializablePairLongFloat;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.firstlast.FirstLastUtils;
import org.apache.druid.query.aggregation.firstlast.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregator;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastBufferAggregator;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastVectorAggregator;
import org.apache.druid.query.aggregation.firstlast.last.GenericLastAggregateCombiner;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.NilColumnValueSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.Types;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

@JsonTypeName(value="floatLast")
public class FloatLastAggregatorFactory
extends AggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex("serializablePairLongFloat");
    private static final Aggregator NIL_AGGREGATOR = new FloatLastAggregator(NilColumnValueSelector.instance(), NilColumnValueSelector.instance(), false){

        @Override
        public void aggregate() {
        }
    };
    private static final BufferAggregator NIL_BUFFER_AGGREGATOR = new FloatLastBufferAggregator(NilColumnValueSelector.instance(), NilColumnValueSelector.instance(), false){

        @Override
        public void aggregate(ByteBuffer buf, int position) {
        }
    };
    private final String fieldName;
    private final String timeColumn;
    private final String name;

    @JsonCreator
    public FloatLastAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="timeColumn") @Nullable String timeColumn) {
        Preconditions.checkNotNull((Object)name, (Object)"Must have a valid, non-null aggregator name");
        Preconditions.checkNotNull((Object)fieldName, (Object)"Must have a valid, non-null fieldName");
        this.name = name;
        this.fieldName = fieldName;
        this.timeColumn = timeColumn == null ? "__time" : timeColumn;
    }

    @Override
    public Aggregator factorize(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_AGGREGATOR;
        }
        return new FloatLastAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongFloat.class));
    }

    @Override
    public BufferAggregator factorizeBuffered(ColumnSelectorFactory metricFactory) {
        ColumnValueSelector valueSelector = metricFactory.makeColumnValueSelector(this.fieldName);
        if (valueSelector instanceof NilColumnValueSelector) {
            return NIL_BUFFER_AGGREGATOR;
        }
        return new FloatLastBufferAggregator(metricFactory.makeColumnValueSelector(this.timeColumn), valueSelector, FirstLastUtils.selectorNeedsFoldCheck(valueSelector, metricFactory.getColumnCapabilities(this.fieldName), SerializablePairLongFloat.class));
    }

    @Override
    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    @Override
    public VectorAggregator factorizeVector(VectorColumnSelectorFactory columnSelectorFactory) {
        VectorValueSelector timeSelector = columnSelectorFactory.makeValueSelector(this.timeColumn);
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.fieldName);
        if (Types.isNumeric(capabilities)) {
            VectorValueSelector valueSelector = columnSelectorFactory.makeValueSelector(this.fieldName);
            return new FloatLastVectorAggregator(timeSelector, valueSelector);
        }
        VectorObjectSelector objectSelector = columnSelectorFactory.makeObjectSelector(this.fieldName);
        return new FloatLastVectorAggregator(timeSelector, objectSelector);
    }

    @Override
    public Comparator getComparator() {
        return FloatFirstAggregatorFactory.VALUE_COMPARATOR;
    }

    @Override
    @Nullable
    public Object combine(@Nullable Object lhs, @Nullable Object rhs) {
        if (rhs == null) {
            return lhs;
        }
        if (lhs == null) {
            return rhs;
        }
        Long leftTime = (Long)((SerializablePair)lhs).lhs;
        Long rightTime = (Long)((SerializablePair)rhs).lhs;
        if (leftTime >= rightTime) {
            return lhs;
        }
        return rhs;
    }

    @Override
    public AggregateCombiner makeAggregateCombiner() {
        return new GenericLastAggregateCombiner<SerializablePairLongFloat>(SerializablePairLongFloat.class);
    }

    @Override
    public AggregatorFactory getCombiningFactory() {
        return new FloatLastAggregatorFactory(this.name, this.name, this.timeColumn);
    }

    @Override
    public Object deserialize(Object object) {
        Map map = (Map)object;
        if (map.get("rhs") == null) {
            return new SerializablePairLongFloat(((Number)map.get("lhs")).longValue(), null);
        }
        return new SerializablePairLongFloat(((Number)map.get("lhs")).longValue(), Float.valueOf(((Number)map.get("rhs")).floatValue()));
    }

    @Override
    @Nullable
    public Object finalizeComputation(@Nullable Object object) {
        return object == null ? null : (Float)((SerializablePairLongFloat)object).rhs;
    }

    @Override
    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonProperty
    public String getTimeColumn() {
        return this.timeColumn;
    }

    @Override
    public List<String> requiredFields() {
        return Arrays.asList(this.timeColumn, this.fieldName);
    }

    @Override
    public byte[] getCacheKey() {
        return new CacheKeyBuilder(17).appendString(this.fieldName).appendString(this.timeColumn).appendByte((byte)-1).build();
    }

    @Override
    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    public ColumnType getResultType() {
        return ColumnType.FLOAT;
    }

    @Override
    public int getMaxIntermediateSize() {
        return 13;
    }

    @Override
    public AggregatorFactory withName(String newName) {
        return new FloatLastAggregatorFactory(newName, this.getFieldName(), this.getTimeColumn());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FloatLastAggregatorFactory that = (FloatLastAggregatorFactory)o;
        return this.fieldName.equals(that.fieldName) && this.timeColumn.equals(that.timeColumn) && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.fieldName);
    }

    public String toString() {
        return "FloatLastAggregatorFactory{name='" + this.name + '\'' + ", fieldName='" + this.fieldName + '\'' + ", timeColumn='" + this.timeColumn + '\'' + '}';
    }
}

