/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.operator.window.value;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.operator.window.Processor;
import org.apache.druid.query.rowsandcols.RowsAndColumns;
import org.apache.druid.query.rowsandcols.column.Column;
import org.apache.druid.query.rowsandcols.semantic.AppendableRowsAndColumns;

public abstract class WindowValueProcessorBase
implements Processor {
    private final String inputColumn;
    private final String outputColumn;

    public WindowValueProcessorBase(String inputColumn, String outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    @JsonProperty(value="inputColumn")
    public String getInputColumn() {
        return this.inputColumn;
    }

    @JsonProperty(value="outputColumn")
    public String getOutputColumn() {
        return this.outputColumn;
    }

    public RowsAndColumns processInternal(RowsAndColumns input, Function<Column, Column> fn) {
        AppendableRowsAndColumns retVal = RowsAndColumns.expectAppendable(input);
        Column column = input.findColumn(this.inputColumn);
        if (column == null) {
            throw new ISE("column[%s] doesn't exist, but window function FIRST wants it to", this.inputColumn);
        }
        retVal.addColumn(this.outputColumn, fn.apply(column));
        return retVal;
    }

    @Override
    public boolean validateEquivalent(Processor otherProcessor) {
        return this.getClass() == otherProcessor.getClass() && this.intervalValidation((WindowValueProcessorBase)otherProcessor);
    }

    protected boolean intervalValidation(WindowValueProcessorBase other) {
        return this.inputColumn.equals(other.inputColumn);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + this.internalToString() + '}';
    }

    protected String internalToString() {
        return "inputColumn=" + this.inputColumn + ", outputColumn='" + this.outputColumn + '\'';
    }

    @Override
    public List<String> getOutputColumnNames() {
        return Collections.singletonList(this.outputColumn);
    }
}

