/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.timeboundary;

import com.google.inject.Inject;
import it.unimi.dsi.fastutil.Pair;
import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.query.ChainedExecutionQueryRunner;
import org.apache.druid.query.Order;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryWatcher;
import org.apache.druid.query.Result;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.timeboundary.TimeBoundaryQuery;
import org.apache.druid.query.timeboundary.TimeBoundaryQueryQueryToolChest;
import org.apache.druid.query.timeboundary.TimeBoundaryResultValue;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorFactory;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.filter.Filters;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.utils.CollectionUtils;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.ReadableInterval;

public class TimeBoundaryQueryRunnerFactory
implements QueryRunnerFactory<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> {
    private static final TimeBoundaryQueryQueryToolChest TOOL_CHEST = new TimeBoundaryQueryQueryToolChest();
    private final QueryWatcher queryWatcher;

    @Inject
    public TimeBoundaryQueryRunnerFactory(QueryWatcher queryWatcher) {
        this.queryWatcher = queryWatcher;
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> createRunner(Segment segment) {
        return new TimeBoundaryQueryRunner(segment);
    }

    @Override
    public QueryRunner<Result<TimeBoundaryResultValue>> mergeRunners(QueryProcessingPool queryProcessingPool, Iterable<QueryRunner<Result<TimeBoundaryResultValue>>> queryRunners) {
        return new ChainedExecutionQueryRunner<Result<TimeBoundaryResultValue>>(queryProcessingPool, this.queryWatcher, queryRunners);
    }

    @Override
    public QueryToolChest<Result<TimeBoundaryResultValue>, TimeBoundaryQuery> getToolchest() {
        return TOOL_CHEST;
    }

    private static boolean canUseTimeBoundaryInspector(TimeBoundaryQuery query, @Nullable TimeBoundaryInspector timeBoundaryInspector) {
        if (timeBoundaryInspector == null || !timeBoundaryInspector.isMinMaxExact()) {
            return false;
        }
        if (query.getFilter() != null) {
            return false;
        }
        Interval queryInterval = (Interval)CollectionUtils.getOnlyElement(query.getQuerySegmentSpec().getIntervals(), xs -> new IAE("Should only have one interval, got[%s]", xs));
        return queryInterval.contains((ReadableInterval)timeBoundaryInspector.getMinMaxInterval());
    }

    public static CursorBuildSpec makeCursorBuildSpec(TimeBoundaryQuery query) {
        return CursorBuildSpec.builder().setInterval(query.getSingleInterval()).setFilter(Filters.convertToCNFFromQueryContext(query, Filters.toFilter(query.getFilter()))).setVirtualColumns(query.getVirtualColumns()).setQueryContext(query.context()).build();
    }

    private static Pair<DateTime, DateTime> getTimeBoundary(TimeBoundaryQuery query, CursorFactory cursorFactory) {
        DateTime maxTime;
        DateTime minTime;
        block33: {
            Throwable throwable;
            CursorHolder cursorHolder;
            CursorBuildSpec cursorSpec;
            block32: {
                minTime = null;
                maxTime = null;
                if (query.needsMinTime()) {
                    cursorSpec = CursorBuildSpec.builder(TimeBoundaryQueryRunnerFactory.makeCursorBuildSpec(query)).setPreferredOrdering(Cursors.ascendingTimeOrder()).build();
                    cursorHolder = cursorFactory.makeCursorHolder(cursorSpec);
                    throwable = null;
                    try {
                        if (cursorHolder.getTimeOrder() == Order.ASCENDING) {
                            minTime = TimeBoundaryQueryRunnerFactory.getFirstTimestamp(query, cursorHolder);
                            break block32;
                        }
                        Pair<DateTime, DateTime> pair = TimeBoundaryQueryRunnerFactory.getTimeBoundaryFullScan(query, cursorHolder);
                        return pair;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (cursorHolder != null) {
                            if (throwable != null) {
                                try {
                                    cursorHolder.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                cursorHolder.close();
                            }
                        }
                    }
                }
            }
            if (query.needsMaxTime()) {
                cursorSpec = CursorBuildSpec.builder(TimeBoundaryQueryRunnerFactory.makeCursorBuildSpec(query)).setPreferredOrdering(Cursors.descendingTimeOrder()).build();
                cursorHolder = cursorFactory.makeCursorHolder(cursorSpec);
                throwable = null;
                try {
                    if (cursorHolder.getTimeOrder() == Order.DESCENDING) {
                        maxTime = TimeBoundaryQueryRunnerFactory.getFirstTimestamp(query, cursorHolder);
                        break block33;
                    }
                    Pair<DateTime, DateTime> pair = TimeBoundaryQueryRunnerFactory.getTimeBoundaryFullScan(query, cursorHolder);
                    return pair;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (cursorHolder != null) {
                        if (throwable != null) {
                            try {
                                cursorHolder.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            cursorHolder.close();
                        }
                    }
                }
            }
        }
        return Pair.of(minTime, maxTime);
    }

    @Nullable
    private static DateTime getFirstTimestamp(TimeBoundaryQuery query, CursorHolder cursorHolder) {
        if (query.context().getVectorize().shouldVectorize(cursorHolder.canVectorize())) {
            return TimeBoundaryQueryRunnerFactory.getFirstTimestampVectorized(cursorHolder.asVectorCursor());
        }
        return TimeBoundaryQueryRunnerFactory.getFirstTimestampNonVectorized(cursorHolder.asCursor());
    }

    @Nullable
    private static DateTime getFirstTimestampVectorized(@Nullable VectorCursor cursor) {
        if (cursor == null || cursor.isDone()) {
            return null;
        }
        VectorValueSelector timestampSelector = cursor.getColumnSelectorFactory().makeValueSelector("__time");
        long[] timeVector = timestampSelector.getLongVector();
        return DateTimes.utc(timeVector[0]);
    }

    @Nullable
    private static DateTime getFirstTimestampNonVectorized(@Nullable Cursor cursor) {
        if (cursor == null || cursor.isDone()) {
            return null;
        }
        ColumnValueSelector timestampSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
        return DateTimes.utc(timestampSelector.getLong());
    }

    private static Pair<DateTime, DateTime> getTimeBoundaryFullScan(TimeBoundaryQuery query, CursorHolder cursorHolder) {
        if (query.context().getVectorize().shouldVectorize(cursorHolder.canVectorize())) {
            return TimeBoundaryQueryRunnerFactory.getTimeBoundaryFullScanVectorized(query, cursorHolder.asVectorCursor());
        }
        return TimeBoundaryQueryRunnerFactory.getTimeBoundaryFullScanNonVectorized(query, cursorHolder.asCursor());
    }

    private static Pair<DateTime, DateTime> getTimeBoundaryFullScanVectorized(TimeBoundaryQuery query, @Nullable VectorCursor cursor) {
        if (cursor == null || cursor.isDone()) {
            return Pair.of(null, null);
        }
        VectorValueSelector timeSelector = cursor.getColumnSelectorFactory().makeValueSelector("__time");
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        while (!cursor.isDone()) {
            long[] timeVector = timeSelector.getLongVector();
            for (int i = 0; i < cursor.getCurrentVectorSize(); ++i) {
                long timestamp = timeVector[i];
                minTime = Math.min(minTime, timestamp);
                maxTime = Math.max(maxTime, timestamp);
            }
            cursor.advance();
        }
        return Pair.of((Object)(query.needsMinTime() ? DateTimes.utc(minTime) : null), (Object)(query.needsMaxTime() ? DateTimes.utc(maxTime) : null));
    }

    private static Pair<DateTime, DateTime> getTimeBoundaryFullScanNonVectorized(TimeBoundaryQuery query, @Nullable Cursor cursor) {
        if (cursor == null || cursor.isDone()) {
            return Pair.of(null, null);
        }
        ColumnValueSelector timeSelector = cursor.getColumnSelectorFactory().makeColumnValueSelector("__time");
        long minTime = Long.MAX_VALUE;
        long maxTime = Long.MIN_VALUE;
        while (!cursor.isDone()) {
            long timestamp = timeSelector.getLong();
            minTime = Math.min(minTime, timestamp);
            maxTime = Math.max(maxTime, timestamp);
            cursor.advance();
        }
        return Pair.of((Object)(query.needsMinTime() ? DateTimes.utc(minTime) : null), (Object)(query.needsMaxTime() ? DateTimes.utc(maxTime) : null));
    }

    private static class TimeBoundaryQueryRunner
    implements QueryRunner<Result<TimeBoundaryResultValue>> {
        private final CursorFactory cursorFactory;
        private final Interval dataInterval;
        @Nullable
        private final TimeBoundaryInspector timeBoundaryInspector;

        public TimeBoundaryQueryRunner(Segment segment) {
            this.cursorFactory = segment.asCursorFactory();
            this.dataInterval = segment.getDataInterval();
            this.timeBoundaryInspector = segment.as(TimeBoundaryInspector.class);
        }

        @Override
        public Sequence<Result<TimeBoundaryResultValue>> run(QueryPlus<Result<TimeBoundaryResultValue>> queryPlus, ResponseContext responseContext) {
            Query<Result<TimeBoundaryResultValue>> input = queryPlus.getQuery();
            if (!(input instanceof TimeBoundaryQuery)) {
                throw new ISE("Got a [%s] which isn't a %s", input.getClass(), TimeBoundaryQuery.class);
            }
            final TimeBoundaryQuery query = (TimeBoundaryQuery)input;
            return new BaseSequence<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(new BaseSequence.IteratorMaker<Result<TimeBoundaryResultValue>, Iterator<Result<TimeBoundaryResultValue>>>(){

                @Override
                public Iterator<Result<TimeBoundaryResultValue>> make() {
                    if (cursorFactory == null) {
                        throw new ISE("Null cursor factory found. Probably trying to issue a query against a segment being memory unmapped.", new Object[0]);
                    }
                    DateTime minTime = null;
                    DateTime maxTime = null;
                    if (TimeBoundaryQueryRunnerFactory.canUseTimeBoundaryInspector(query, timeBoundaryInspector)) {
                        if (query.needsMinTime()) {
                            minTime = timeBoundaryInspector.getMinTime();
                        }
                        if (query.needsMaxTime()) {
                            maxTime = timeBoundaryInspector.getMaxTime();
                        }
                    } else {
                        Pair timeBoundary = TimeBoundaryQueryRunnerFactory.getTimeBoundary(query, cursorFactory);
                        minTime = (DateTime)timeBoundary.left();
                        maxTime = (DateTime)timeBoundary.right();
                    }
                    return query.buildResult(dataInterval.getStart(), minTime, maxTime).iterator();
                }

                @Override
                public void cleanup(Iterator<Result<TimeBoundaryResultValue>> toClean) {
                }
            });
        }
    }
}

