/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.topn;

import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.topn.TopNAlgorithm;
import org.apache.druid.query.topn.TopNCursorInspector;
import org.apache.druid.query.topn.TopNMetricSpecBuilder;
import org.apache.druid.query.topn.TopNParams;
import org.apache.druid.query.topn.TopNQuery;
import org.apache.druid.query.topn.TopNQueryMetrics;
import org.apache.druid.query.topn.TopNResultBuilder;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.IdLookup;
import org.apache.druid.segment.TopNOptimizationInspector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.joda.time.ReadableInterval;

public abstract class BaseTopNAlgorithm<DimValSelector, DimValAggregateStore, Parameters extends TopNParams>
implements TopNAlgorithm<DimValSelector, Parameters> {
    protected TopNCursorInspector cursorInspector;

    public static Aggregator[] makeAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        Aggregator[] aggregators = new Aggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorize(cursor.getColumnSelectorFactory());
            ++aggregatorIndex;
        }
        return aggregators;
    }

    protected static BufferAggregator[] makeBufferAggregators(Cursor cursor, List<AggregatorFactory> aggregatorSpecs) {
        BufferAggregator[] aggregators = new BufferAggregator[aggregatorSpecs.size()];
        int aggregatorIndex = 0;
        for (AggregatorFactory spec : aggregatorSpecs) {
            aggregators[aggregatorIndex] = spec.factorizeBuffered(cursor.getColumnSelectorFactory());
            ++aggregatorIndex;
        }
        return aggregators;
    }

    protected BaseTopNAlgorithm(TopNCursorInspector cursorInspector) {
        this.cursorInspector = cursorInspector;
    }

    @Override
    public void run(Parameters params, TopNResultBuilder resultBuilder, DimValSelector dimValSelector, @Nullable TopNQueryMetrics queryMetrics) {
        if (((TopNParams)params).getCardinality() != -1) {
            this.runWithCardinalityKnown(params, resultBuilder, dimValSelector, queryMetrics);
        } else {
            this.runWithCardinalityUnknown(params, resultBuilder, queryMetrics);
        }
    }

    private void runWithCardinalityKnown(Parameters params, TopNResultBuilder resultBuilder, DimValSelector dimValSelector, @Nullable TopNQueryMetrics queryMetrics) {
        if (queryMetrics != null) {
            queryMetrics.startRecordingScanTime();
        }
        boolean hasDimValSelector = dimValSelector != null;
        int cardinality = ((TopNParams)params).getCardinality();
        int numProcessed = 0;
        long processedRows = 0L;
        while (numProcessed < cardinality) {
            DimValSelector theDimValSelector;
            int numToProcess;
            int maxNumToProcess = Math.min(((TopNParams)params).getNumValuesPerPass(), cardinality - numProcessed);
            if (!hasDimValSelector) {
                numToProcess = maxNumToProcess;
                theDimValSelector = this.makeDimValSelector(params, numProcessed, numToProcess);
            } else {
                numToProcess = this.computeNewLength(dimValSelector, numProcessed, maxNumToProcess);
                theDimValSelector = this.updateDimValSelector(dimValSelector, numProcessed, numToProcess);
            }
            DimValAggregateStore aggregatesStore = this.makeDimValAggregateStore(params);
            processedRows = this.scanAndAggregate(params, theDimValSelector, aggregatesStore);
            this.updateResults(params, theDimValSelector, aggregatesStore, resultBuilder);
            this.resetAggregators(aggregatesStore);
            if ((numProcessed += numToProcess) >= cardinality) continue;
            ((TopNParams)params).getCursor().reset();
        }
        if (queryMetrics != null) {
            queryMetrics.addProcessedRows(processedRows);
            queryMetrics.stopRecordingScanTime();
        }
    }

    private void runWithCardinalityUnknown(Parameters params, TopNResultBuilder resultBuilder, @Nullable TopNQueryMetrics queryMetrics) {
        DimValAggregateStore aggregatesStore = this.makeDimValAggregateStore(params);
        if (queryMetrics != null) {
            queryMetrics.startRecordingScanTime();
        }
        long processedRows = this.scanAndAggregate(params, null, aggregatesStore);
        this.updateResults(params, null, aggregatesStore, resultBuilder);
        this.resetAggregators(aggregatesStore);
        if (queryMetrics != null) {
            queryMetrics.addProcessedRows(processedRows);
            queryMetrics.stopRecordingScanTime();
        }
    }

    protected abstract DimValSelector makeDimValSelector(Parameters var1, int var2, int var3);

    protected int computeNewLength(DimValSelector dimValSelector, int numProcessed, int numToProcess) {
        return numToProcess;
    }

    protected abstract DimValSelector updateDimValSelector(DimValSelector var1, int var2, int var3);

    protected abstract DimValAggregateStore makeDimValAggregateStore(Parameters var1);

    protected abstract long scanAndAggregate(Parameters var1, DimValSelector var2, DimValAggregateStore var3);

    protected abstract void updateResults(Parameters var1, DimValSelector var2, DimValAggregateStore var3, TopNResultBuilder var4);

    protected abstract void resetAggregators(DimValAggregateStore var1);

    public static TopNResultBuilder makeResultBuilder(TopNParams params, TopNQuery query) {
        Comparator comparator = query.getTopNMetricSpec().getComparator(query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
        return query.getTopNMetricSpec().getResultBuilder(params.getGranularizer().getBucketStart(), query.getDimensionSpec(), query.getThreshold(), comparator, query.getAggregatorSpecs(), query.getPostAggregatorSpecs());
    }

    protected static abstract class BaseArrayProvider<T>
    implements TopNMetricSpecBuilder<T> {
        private volatile String previousStop;
        private volatile boolean ignoreAfterThreshold;
        private volatile int ignoreFirstN;
        private volatile int keepOnlyN;
        private final IdLookup idLookup;
        private final TopNQuery query;
        private final TopNCursorInspector cursorInspector;

        public BaseArrayProvider(DimensionSelector dimSelector, TopNQuery query, TopNCursorInspector cursorInspector) {
            this.idLookup = dimSelector.idLookup();
            this.query = query;
            this.cursorInspector = cursorInspector;
            this.previousStop = null;
            this.ignoreAfterThreshold = false;
            this.ignoreFirstN = 0;
            this.keepOnlyN = dimSelector.getValueCardinality();
            if (this.keepOnlyN < 0) {
                throw new IAE("Cannot operate on a dimension with no dictionary", new Object[0]);
            }
        }

        @Override
        public void skipTo(String previousStop) {
            ColumnCapabilities capabilities = this.cursorInspector.getColumnInspector().getColumnCapabilities(this.query.getDimensionSpec().getDimension());
            if (capabilities != null && capabilities.areDictionaryValuesSorted().isTrue()) {
                this.previousStop = previousStop;
            }
        }

        @Override
        public void ignoreAfterThreshold() {
            this.ignoreAfterThreshold = true;
        }

        @Override
        public void ignoreFirstN(int n) {
            this.ignoreFirstN = n;
        }

        @Override
        public void keepOnlyN(int n) {
            this.keepOnlyN = n;
        }

        @VisibleForTesting
        public Pair<Integer, Integer> computeStartEnd(int cardinality) {
            int startIndex = this.ignoreFirstN;
            if (this.previousStop != null) {
                if (this.idLookup == null) {
                    throw new UnsupportedOperationException("Only DimensionSelectors which support idLookup() are supported yet");
                }
                int lookupId = this.idLookup.lookupId(this.previousStop) + 1;
                if (lookupId < 0) {
                    lookupId *= -1;
                }
                startIndex = lookupId > this.ignoreFirstN + this.keepOnlyN ? this.ignoreFirstN + this.keepOnlyN : Math.max(lookupId, startIndex);
            }
            int endIndex = Math.min(this.ignoreFirstN + this.keepOnlyN, cardinality);
            TopNOptimizationInspector topNOptimizationInspector = this.cursorInspector.getOptimizationInspector();
            if (this.ignoreAfterThreshold && this.query.getDimensionsFilter() == null && topNOptimizationInspector != null && topNOptimizationInspector.areAllDictionaryIdsPresent() && this.query.getIntervals().stream().anyMatch(interval -> interval.contains((ReadableInterval)this.cursorInspector.getDataInterval()))) {
                endIndex = Math.min(endIndex, startIndex + this.query.getThreshold());
            }
            return Pair.of(startIndex, endIndex);
        }
    }

    public static class AggregatorArrayProvider
    extends BaseArrayProvider<Aggregator[][]> {
        Aggregator[][] expansionAggs;
        int cardinality;

        public AggregatorArrayProvider(DimensionSelector dimSelector, TopNQuery query, TopNCursorInspector cursorInspector, int cardinality) {
            super(dimSelector, query, cursorInspector);
            this.expansionAggs = new Aggregator[cardinality][];
            this.cardinality = cardinality;
        }

        @Override
        public Aggregator[][] build() {
            Pair startEnd = this.computeStartEnd(this.cardinality);
            Arrays.fill((Object[])this.expansionAggs, 0, (int)((Integer)startEnd.lhs), TopNAlgorithm.EMPTY_ARRAY);
            Arrays.fill((Object[])this.expansionAggs, (int)((Integer)startEnd.lhs), (int)((Integer)startEnd.rhs), null);
            Arrays.fill((Object[])this.expansionAggs, (int)((Integer)startEnd.rhs), this.expansionAggs.length, TopNAlgorithm.EMPTY_ARRAY);
            return this.expansionAggs;
        }
    }
}

