/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.BaseDoubleColumnValueSelector;
import org.apache.druid.segment.BaseFloatColumnValueSelector;
import org.apache.druid.segment.BaseLongColumnValueSelector;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.ColumnProcessorFactory;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VectorColumnProcessorFactory;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.NilVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;
import org.apache.druid.segment.virtual.ExpressionSelectors;

public class ColumnProcessors {
    public static final ColumnCapabilities NIL_COLUMN_CAPABILITIES = new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(true).setDictionaryValuesUnique(true).setDictionaryValuesSorted(true).setHasBitmapIndexes(false).setHasMultipleValues(false);

    public static <T> T makeProcessor(String column, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> factory.getColumnCapabilities(column)), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> factory.makeDimensionSelector(DefaultDimensionSpec.of(column))), factory -> factory.makeColumnValueSelector(column), processorFactory, selectorFactory);
    }

    public static <T> T makeProcessor(DimensionSpec dimensionSpec, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> ColumnProcessors.computeDimensionSpecCapabilities(dimensionSpec, factory.getColumnCapabilities(dimensionSpec.getDimension()))), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> factory.makeDimensionSelector(dimensionSpec)), factory -> factory.makeColumnValueSelector(dimensionSpec.getDimension()), processorFactory, selectorFactory);
    }

    public static <T> T makeProcessor(Expr expr, ColumnType exprTypeHint, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        Preconditions.checkNotNull((Object)exprTypeHint, (Object)"'exprTypeHint' must be nonnull");
        if (expr.getBindingIfIdentifier() != null) {
            return ColumnProcessors.makeProcessor(expr.getBindingIfIdentifier(), processorFactory, selectorFactory);
        }
        return ColumnProcessors.makeProcessorInternal((Function<ColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> new ColumnCapabilitiesImpl().setType(exprTypeHint).setHasMultipleValues(true).setDictionaryValuesUnique(false).setDictionaryValuesSorted(false)), (Function<ColumnSelectorFactory, DimensionSelector>)((Function)factory -> ExpressionSelectors.makeDimensionSelector(factory, expr, null)), factory -> ExpressionSelectors.makeColumnValueSelector(factory, expr), processorFactory, selectorFactory);
    }

    public static <T> T makeVectorProcessor(String column, VectorColumnProcessorFactory<T> processorFactory, VectorColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeVectorProcessorInternal((Function<VectorColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> factory.getColumnCapabilities(column)), (Function<VectorColumnSelectorFactory, SingleValueDimensionVectorSelector>)((Function)factory -> factory.makeSingleValueDimensionSelector(DefaultDimensionSpec.of(column))), (Function<VectorColumnSelectorFactory, MultiValueDimensionVectorSelector>)((Function)factory -> factory.makeMultiValueDimensionSelector(DefaultDimensionSpec.of(column))), (Function<VectorColumnSelectorFactory, VectorValueSelector>)((Function)factory -> factory.makeValueSelector(column)), (Function<VectorColumnSelectorFactory, VectorObjectSelector>)((Function)factory -> factory.makeObjectSelector(column)), processorFactory, selectorFactory);
    }

    public static <T> T makeVectorProcessor(DimensionSpec dimensionSpec, VectorColumnProcessorFactory<T> processorFactory, VectorColumnSelectorFactory selectorFactory) {
        return ColumnProcessors.makeVectorProcessorInternal((Function<VectorColumnSelectorFactory, ColumnCapabilities>)((Function)factory -> ColumnProcessors.computeDimensionSpecCapabilities(dimensionSpec, factory.getColumnCapabilities(dimensionSpec.getDimension()))), (Function<VectorColumnSelectorFactory, SingleValueDimensionVectorSelector>)((Function)factory -> factory.makeSingleValueDimensionSelector(dimensionSpec)), (Function<VectorColumnSelectorFactory, MultiValueDimensionVectorSelector>)((Function)factory -> factory.makeMultiValueDimensionSelector(dimensionSpec)), (Function<VectorColumnSelectorFactory, VectorValueSelector>)((Function)factory -> factory.makeValueSelector(dimensionSpec.getDimension())), (Function<VectorColumnSelectorFactory, VectorObjectSelector>)((Function)factory -> factory.makeObjectSelector(dimensionSpec.getDimension())), processorFactory, selectorFactory);
    }

    @Nullable
    private static ColumnCapabilities computeDimensionSpecCapabilities(DimensionSpec dimensionSpec, @Nullable ColumnCapabilities columnCapabilities) {
        if (dimensionSpec.mustDecorate()) {
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING);
        }
        if (dimensionSpec.getExtractionFn() != null) {
            boolean sorted;
            boolean unique;
            boolean dictionaryEncoded;
            if (columnCapabilities != null) {
                dictionaryEncoded = columnCapabilities.isDictionaryEncoded().isTrue();
                unique = columnCapabilities.areDictionaryValuesUnique().isTrue();
                sorted = columnCapabilities.areDictionaryValuesSorted().isTrue();
            } else {
                dictionaryEncoded = false;
                unique = false;
                sorted = false;
            }
            return new ColumnCapabilitiesImpl().setType(ColumnType.STRING).setDictionaryEncoded(dictionaryEncoded).setDictionaryValuesSorted(sorted && dimensionSpec.getExtractionFn().preservesOrdering()).setDictionaryValuesUnique(unique && dimensionSpec.getExtractionFn().getExtractionType() == ExtractionFn.ExtractionType.ONE_TO_ONE).setHasMultipleValues(ColumnProcessors.mayBeMultiValue(columnCapabilities));
        }
        return columnCapabilities;
    }

    private static <T> T makeProcessorInternal(Function<ColumnSelectorFactory, ColumnCapabilities> inputCapabilitiesFn, Function<ColumnSelectorFactory, DimensionSelector> dimensionSelectorFn, Function<ColumnSelectorFactory, ColumnValueSelector<?>> valueSelectorFunction, ColumnProcessorFactory<T> processorFactory, ColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = (ColumnCapabilities)inputCapabilitiesFn.apply((Object)selectorFactory);
        TypeSignature<ValueType> effectiveType = capabilities != null ? capabilities : processorFactory.defaultType();
        switch (effectiveType.getType()) {
            case STRING: {
                return processorFactory.makeDimensionProcessor((DimensionSelector)dimensionSelectorFn.apply((Object)selectorFactory), ColumnProcessors.mayBeMultiValue(capabilities));
            }
            case LONG: {
                return processorFactory.makeLongProcessor((BaseLongColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case FLOAT: {
                return processorFactory.makeFloatProcessor((BaseFloatColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case DOUBLE: {
                return processorFactory.makeDoubleProcessor((BaseDoubleColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
            case ARRAY: {
                return processorFactory.makeArrayProcessor((BaseObjectColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory), capabilities);
            }
            case COMPLEX: {
                return processorFactory.makeComplexProcessor((BaseObjectColumnValueSelector)valueSelectorFunction.apply((Object)selectorFactory));
            }
        }
        throw new ISE("Unsupported type[%s]", effectiveType.asTypeString());
    }

    private static <T> T makeVectorProcessorInternal(Function<VectorColumnSelectorFactory, ColumnCapabilities> inputCapabilitiesFn, Function<VectorColumnSelectorFactory, SingleValueDimensionVectorSelector> singleValueDimensionSelectorFn, Function<VectorColumnSelectorFactory, MultiValueDimensionVectorSelector> multiValueDimensionSelectorFn, Function<VectorColumnSelectorFactory, VectorValueSelector> valueSelectorFn, Function<VectorColumnSelectorFactory, VectorObjectSelector> objectSelectorFn, VectorColumnProcessorFactory<T> processorFactory, VectorColumnSelectorFactory selectorFactory) {
        ColumnCapabilities capabilities = (ColumnCapabilities)inputCapabilitiesFn.apply((Object)selectorFactory);
        if (capabilities == null) {
            return processorFactory.makeSingleValueDimensionProcessor(NIL_COLUMN_CAPABILITIES, NilVectorSelector.create(selectorFactory.getReadableVectorInspector()));
        }
        switch ((ValueType)capabilities.getType()) {
            case STRING: {
                if (!processorFactory.useDictionaryEncodedSelector(capabilities)) {
                    return processorFactory.makeObjectProcessor(capabilities, (VectorObjectSelector)objectSelectorFn.apply((Object)selectorFactory));
                }
                if (capabilities.hasMultipleValues().isMaybeTrue()) {
                    return processorFactory.makeMultiValueDimensionProcessor(capabilities, (MultiValueDimensionVectorSelector)multiValueDimensionSelectorFn.apply((Object)selectorFactory));
                }
                return processorFactory.makeSingleValueDimensionProcessor(capabilities, (SingleValueDimensionVectorSelector)singleValueDimensionSelectorFn.apply((Object)selectorFactory));
            }
            case LONG: {
                return processorFactory.makeLongProcessor(capabilities, (VectorValueSelector)valueSelectorFn.apply((Object)selectorFactory));
            }
            case FLOAT: {
                return processorFactory.makeFloatProcessor(capabilities, (VectorValueSelector)valueSelectorFn.apply((Object)selectorFactory));
            }
            case DOUBLE: {
                return processorFactory.makeDoubleProcessor(capabilities, (VectorValueSelector)valueSelectorFn.apply((Object)selectorFactory));
            }
            case ARRAY: {
                return processorFactory.makeArrayProcessor(capabilities, (VectorObjectSelector)objectSelectorFn.apply((Object)selectorFactory));
            }
            case COMPLEX: {
                return processorFactory.makeObjectProcessor(capabilities, (VectorObjectSelector)objectSelectorFn.apply((Object)selectorFactory));
            }
        }
        throw new ISE("Unsupported type[%s]", capabilities.getType());
    }

    private static boolean mayBeMultiValue(@Nullable ColumnCapabilities capabilities) {
        return capabilities == null || capabilities.hasMultipleValues().isMaybeTrue();
    }
}

