/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.apache.druid.data.input.impl.TimestampSpec;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.AggregateProjectionMetadata;
import org.apache.druid.segment.Cursors;

public class Metadata {
    private final Map<String, Object> container;
    @Nullable
    private final AggregatorFactory[] aggregators;
    @Nullable
    private final TimestampSpec timestampSpec;
    @Nullable
    private final Granularity queryGranularity;
    @Nullable
    private final Boolean rollup;
    @Nullable
    private final List<OrderBy> ordering;
    @Nullable
    private final List<AggregateProjectionMetadata> projections;

    public Metadata(@JsonProperty(value="container") @Nullable Map<String, Object> container, @JsonProperty(value="aggregators") @Nullable AggregatorFactory[] aggregators, @JsonProperty(value="timestampSpec") @Nullable TimestampSpec timestampSpec, @JsonProperty(value="queryGranularity") @Nullable Granularity queryGranularity, @JsonProperty(value="rollup") @Nullable Boolean rollup, @JsonProperty(value="ordering") @Nullable List<OrderBy> ordering, @JsonProperty(value="projections") @Nullable List<AggregateProjectionMetadata> projections) {
        this.container = container == null ? new ConcurrentHashMap() : container;
        this.aggregators = aggregators;
        this.timestampSpec = timestampSpec;
        this.queryGranularity = queryGranularity;
        this.rollup = rollup;
        this.ordering = ordering;
        this.projections = projections;
    }

    @JsonProperty
    public Map<String, Object> getContainer() {
        return this.container;
    }

    @JsonProperty
    @Nullable
    public AggregatorFactory[] getAggregators() {
        return this.aggregators;
    }

    @JsonProperty
    @Nullable
    public TimestampSpec getTimestampSpec() {
        return this.timestampSpec;
    }

    @JsonProperty
    @Nullable
    public Granularity getQueryGranularity() {
        return this.queryGranularity;
    }

    @JsonProperty
    @Nullable
    public Boolean isRollup() {
        return this.rollup;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public List<AggregateProjectionMetadata> getProjections() {
        return this.projections;
    }

    public Metadata withProjections(List<AggregateProjectionMetadata> projections) {
        return new Metadata(this.container, this.aggregators, this.timestampSpec, this.queryGranularity, this.rollup, this.ordering, projections);
    }

    public Metadata putAll(@Nullable Map<String, Object> other) {
        if (other != null) {
            this.container.putAll(other);
        }
        return this;
    }

    @Nullable
    public static Metadata merge(@Nullable List<Metadata> toBeMerged, @Nullable AggregatorFactory[] overrideMergedAggregators) {
        if (toBeMerged == null || toBeMerged.size() == 0) {
            return null;
        }
        boolean foundSomeMetadata = false;
        HashMap<String, Object> mergedContainer = new HashMap<String, Object>();
        ArrayList<AggregatorFactory[]> aggregatorsToMerge = overrideMergedAggregators == null ? new ArrayList<AggregatorFactory[]>() : null;
        ArrayList<TimestampSpec> timestampSpecsToMerge = new ArrayList<TimestampSpec>();
        ArrayList<Granularity> gransToMerge = new ArrayList<Granularity>();
        ArrayList<Boolean> rollupToMerge = new ArrayList<Boolean>();
        ArrayList<List<OrderBy>> orderingsToMerge = new ArrayList<List<OrderBy>>();
        ArrayList<List<AggregateProjectionMetadata>> projectionsToMerge = new ArrayList<List<AggregateProjectionMetadata>>();
        for (Metadata metadata : toBeMerged) {
            if (metadata != null) {
                foundSomeMetadata = true;
                if (aggregatorsToMerge != null) {
                    aggregatorsToMerge.add(metadata.getAggregators());
                }
                if (timestampSpecsToMerge != null && metadata.getTimestampSpec() != null) {
                    timestampSpecsToMerge.add(metadata.getTimestampSpec());
                }
                if (gransToMerge != null) {
                    gransToMerge.add(metadata.getQueryGranularity());
                }
                if (rollupToMerge != null) {
                    rollupToMerge.add(metadata.isRollup());
                }
                orderingsToMerge.add(metadata.getOrdering());
                projectionsToMerge.add(metadata.getProjections());
                mergedContainer.putAll(metadata.container);
                continue;
            }
            aggregatorsToMerge = null;
            timestampSpecsToMerge = null;
            gransToMerge = null;
            rollupToMerge = null;
        }
        if (!foundSomeMetadata) {
            return null;
        }
        AggregatorFactory[] mergedAggregators = aggregatorsToMerge == null ? overrideMergedAggregators : AggregatorFactory.mergeAggregators(aggregatorsToMerge);
        TimestampSpec mergedTimestampSpec = timestampSpecsToMerge == null ? null : TimestampSpec.mergeTimestampSpec(timestampSpecsToMerge);
        Granularity mergedGranularity = gransToMerge == null ? null : Granularity.mergeGranularities(gransToMerge);
        List<OrderBy> mergedOrdering = Metadata.mergeOrderings(orderingsToMerge);
        Metadata.validateProjections(projectionsToMerge);
        Boolean rollup = null;
        if (rollupToMerge != null && !rollupToMerge.isEmpty()) {
            rollup = (Boolean)rollupToMerge.get(0);
            for (Boolean r : rollupToMerge) {
                if (r == null) {
                    rollup = null;
                    break;
                }
                if (!r.equals(rollup)) {
                    rollup = null;
                    break;
                }
                rollup = r;
            }
        }
        return new Metadata(mergedContainer, mergedAggregators, mergedTimestampSpec, mergedGranularity, rollup, mergedOrdering, (List)projectionsToMerge.get(0));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Metadata metadata = (Metadata)o;
        return Objects.equals(this.container, metadata.container) && Arrays.equals(this.aggregators, metadata.aggregators) && Objects.equals(this.timestampSpec, metadata.timestampSpec) && Objects.equals(this.queryGranularity, metadata.queryGranularity) && Objects.equals(this.rollup, metadata.rollup) && Objects.equals(this.ordering, metadata.ordering) && Objects.equals(this.projections, metadata.projections);
    }

    public int hashCode() {
        return Objects.hash(this.container, Arrays.hashCode(this.aggregators), this.timestampSpec, this.queryGranularity, this.rollup, this.ordering, this.projections);
    }

    public String toString() {
        return "Metadata{container=" + this.container + ", aggregators=" + Arrays.toString(this.aggregators) + ", timestampSpec=" + this.timestampSpec + ", queryGranularity=" + this.queryGranularity + ", rollup=" + this.rollup + ", ordering=" + this.ordering + ", projections=" + this.projections + '}';
    }

    public static List<OrderBy> mergeOrderings(List<List<OrderBy>> orderingsToMerge) {
        if (orderingsToMerge.isEmpty()) {
            throw new IAE("orderingsToMerge is empty", new Object[0]);
        }
        ArrayList<OrderBy> mergedOrdering = new ArrayList<OrderBy>();
        while (true) {
            int position = mergedOrdering.size();
            OrderBy orderBy = null;
            for (List<OrderBy> ordering : orderingsToMerge) {
                if (ordering == null) {
                    ordering = Cursors.ascendingTimeOrder();
                }
                if (position < ordering.size()) {
                    if (orderBy == null) {
                        orderBy = ordering.get(position);
                        continue;
                    }
                    if (orderBy.equals(ordering.get(position))) continue;
                    return mergedOrdering;
                }
                return mergedOrdering;
            }
            mergedOrdering.add(orderBy);
        }
    }

    public static void validateProjections(List<List<AggregateProjectionMetadata>> projectionsToMerge) {
        HashMap<String, AggregateProjectionMetadata> projectionsMap = new HashMap<String, AggregateProjectionMetadata>();
        int nullCount = 0;
        int expectedSize = -1;
        for (List<AggregateProjectionMetadata> projections : projectionsToMerge) {
            if (projections == null) {
                ++nullCount;
                continue;
            }
            if (expectedSize < 0) {
                expectedSize = projections.size();
            } else if (projections.size() != expectedSize) {
                throw DruidException.defensive("Unable to merge projections: mismatched projections count", new Object[0]);
            }
            for (AggregateProjectionMetadata projection : projections) {
                AggregateProjectionMetadata prev = projectionsMap.putIfAbsent(projection.getSchema().getName(), projection);
                if (prev == null || prev.getSchema().equals(projection.getSchema())) continue;
                throw DruidException.defensive("Unable to merge projections: mismatched projections [%s] and [%s]", prev, projection);
            }
        }
        if (nullCount > 0 && nullCount != projectionsToMerge.size()) {
            throw DruidException.defensive("Unable to merge projections: some projections were null", new Object[0]);
        }
    }
}

