/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import java.util.Comparator;
import org.apache.druid.data.input.impl.DimensionSchema;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionHandler;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.NestedDataColumnIndexerV4;
import org.apache.druid.segment.NestedDataColumnMergerV4;
import org.apache.druid.segment.NestedDataColumnSchema;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.nested.StructuredData;
import org.apache.druid.segment.selector.settable.SettableColumnValueSelector;
import org.apache.druid.segment.selector.settable.SettableObjectColumnValueSelector;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class NestedDataColumnHandlerV4
implements DimensionHandler<StructuredData, StructuredData, StructuredData> {
    private static Comparator<ColumnValueSelector> COMPARATOR = (s1, s2) -> StructuredData.COMPARATOR.compare(StructuredData.wrap(s1.getObject()), StructuredData.wrap(s2.getObject()));
    private final String name;

    public NestedDataColumnHandlerV4(String name) {
        this.name = name;
    }

    @Override
    public String getDimensionName() {
        return this.name;
    }

    @Override
    public DimensionSpec getDimensionSpec() {
        return new DefaultDimensionSpec(this.name, this.name, ColumnType.NESTED_DATA);
    }

    @Override
    public DimensionSchema getDimensionSchema(ColumnCapabilities capabilities) {
        return new NestedDataColumnSchema(this.name, 4);
    }

    @Override
    public DimensionIndexer<StructuredData, StructuredData, StructuredData> makeIndexer(boolean useMaxMemoryEstimates) {
        return new NestedDataColumnIndexerV4();
    }

    @Override
    public DimensionMergerV9 makeMerger(String outputName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        return new NestedDataColumnMergerV4(outputName, indexSpec, segmentWriteOutMedium, closer);
    }

    @Override
    public int getLengthOfEncodedKeyComponent(StructuredData dimVals) {
        return 1;
    }

    @Override
    public Comparator<ColumnValueSelector> getEncodedValueSelectorComparator() {
        return COMPARATOR;
    }

    @Override
    public SettableColumnValueSelector makeNewSettableEncodedValueSelector() {
        return new SettableObjectColumnValueSelector();
    }
}

