/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.BaseQuery;
import org.apache.druid.query.DefaultBitmapResultFactory;
import org.apache.druid.query.Order;
import org.apache.druid.query.OrderBy;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.filter.Filter;
import org.apache.druid.query.filter.FilterBundle;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.query.filter.ValueMatcher;
import org.apache.druid.query.filter.vector.VectorValueMatcher;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.BitmapOffset;
import org.apache.druid.segment.ColumnCache;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorColumnIndexSelector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.Cursor;
import org.apache.druid.segment.CursorBuildSpec;
import org.apache.druid.segment.CursorHolder;
import org.apache.druid.segment.Cursors;
import org.apache.druid.segment.FilteredOffset;
import org.apache.druid.segment.QueryableIndex;
import org.apache.druid.segment.QueryableIndexColumnSelectorFactory;
import org.apache.druid.segment.SimpleAscendingOffset;
import org.apache.druid.segment.SimpleDescendingOffset;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.NumericColumn;
import org.apache.druid.segment.data.Offset;
import org.apache.druid.segment.data.ReadableOffset;
import org.apache.druid.segment.filter.AndFilter;
import org.apache.druid.segment.historical.HistoricalCursor;
import org.apache.druid.segment.vector.BitmapVectorOffset;
import org.apache.druid.segment.vector.FilteredVectorOffset;
import org.apache.druid.segment.vector.NoFilterVectorOffset;
import org.apache.druid.segment.vector.QueryableIndexVectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorCursor;
import org.apache.druid.segment.vector.VectorOffset;
import org.apache.druid.utils.CloseableUtils;
import org.joda.time.Interval;

public class QueryableIndexCursorHolder
implements CursorHolder {
    private static final Logger log = new Logger(QueryableIndexCursorHolder.class);
    private final QueryableIndex index;
    private final Interval interval;
    private final VirtualColumns virtualColumns;
    @Nullable
    private final List<AggregatorFactory> aggregatorFactories;
    @Nullable
    private final Filter filter;
    @Nullable
    private final QueryMetrics<? extends Query<?>> metrics;
    private final List<OrderBy> ordering;
    private final QueryContext queryContext;
    private final int vectorSize;
    private final Supplier<CursorResources> resourcesSupplier;

    public QueryableIndexCursorHolder(QueryableIndex index, CursorBuildSpec cursorBuildSpec) {
        this.index = index;
        this.interval = cursorBuildSpec.getInterval();
        this.virtualColumns = cursorBuildSpec.getVirtualColumns();
        this.aggregatorFactories = cursorBuildSpec.getAggregators();
        this.filter = cursorBuildSpec.getFilter();
        List<OrderBy> indexOrdering = index.getOrdering();
        this.ordering = Cursors.preferDescendingTimeOrdering(cursorBuildSpec) && Cursors.getTimeOrdering(indexOrdering) == Order.ASCENDING ? Cursors.descendingTimeOrder() : indexOrdering;
        this.queryContext = cursorBuildSpec.getQueryContext();
        this.vectorSize = cursorBuildSpec.getQueryContext().getVectorSize();
        this.metrics = cursorBuildSpec.getQueryMetrics();
        this.resourcesSupplier = Suppliers.memoize(() -> new CursorResources(index, this.virtualColumns, Cursors.getTimeOrdering(this.ordering), this.interval, this.filter, cursorBuildSpec.getQueryContext().getBoolean("cursorAutoArrangeFilters", true), this.metrics));
    }

    @Override
    public boolean canVectorize() {
        CursorResources resources;
        FilterBundle filterBundle;
        ColumnInspector inspector = this.virtualColumns.wrapInspector(this.index);
        if (!this.virtualColumns.isEmpty() && !this.queryContext.getVectorizeVirtualColumns().shouldVectorize(this.virtualColumns.canVectorize(inspector))) {
            return false;
        }
        if (this.aggregatorFactories != null) {
            for (AggregatorFactory factory : this.aggregatorFactories) {
                if (factory.canVectorize(inspector)) continue;
                return false;
            }
        }
        if ((filterBundle = (resources = (CursorResources)this.resourcesSupplier.get()).filterBundle) != null && !filterBundle.canVectorizeMatcher()) {
            return false;
        }
        return Cursors.getTimeOrdering(this.ordering) != Order.DESCENDING;
    }

    @Override
    public Cursor asCursor() {
        if (this.metrics != null) {
            this.metrics.vectorized(false);
        }
        CursorResources resources = (CursorResources)this.resourcesSupplier.get();
        FilterBundle filterBundle = resources.filterBundle;
        int numRows = resources.numRows;
        long minDataTimestamp = resources.minDataTimestamp;
        long maxDataTimestamp = resources.maxDataTimestamp;
        NumericColumn timestamps = resources.timestamps;
        ColumnCache columnCache = resources.columnCache;
        Order timeOrder = resources.timeOrder;
        Offset baseOffset = filterBundle == null || filterBundle.getIndex() == null ? (timeOrder == Order.DESCENDING ? new SimpleDescendingOffset(numRows) : new SimpleAscendingOffset(numRows)) : BitmapOffset.of(filterBundle.getIndex().getBitmap(), timeOrder == Order.DESCENDING, this.index.getNumRows());
        long timeStart = Math.max(this.interval.getStartMillis(), minDataTimestamp);
        long timeEnd = this.interval.getEndMillis();
        if (timeOrder == Order.ASCENDING) {
            while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) < timeStart) {
                baseOffset.increment();
            }
        } else if (timeOrder == Order.DESCENDING) {
            while (baseOffset.withinBounds() && timestamps.getLongSingleValueRow(baseOffset.getOffset()) >= timeEnd) {
                baseOffset.increment();
            }
        }
        Offset offset = timeOrder == Order.ASCENDING ? new AscendingTimestampCheckingOffset(baseOffset, timestamps, timeEnd, maxDataTimestamp < timeEnd) : (timeOrder == Order.DESCENDING ? new DescendingTimestampCheckingOffset(baseOffset, timestamps, timeStart, minDataTimestamp >= timeStart) : baseOffset);
        Offset baseCursorOffset = offset.clone();
        ColumnSelectorFactory columnSelectorFactory = this.makeColumnSelectorFactoryForOffset(columnCache, baseCursorOffset);
        if (filterBundle != null && filterBundle.getMatcherBundle() != null) {
            ValueMatcher matcher = filterBundle.getMatcherBundle().valueMatcher(columnSelectorFactory, baseCursorOffset, timeOrder == Order.DESCENDING);
            FilteredOffset filteredOffset = new FilteredOffset(baseCursorOffset, matcher);
            return new QueryableIndexCursor(filteredOffset, columnSelectorFactory);
        }
        return new QueryableIndexCursor(baseCursorOffset, columnSelectorFactory);
    }

    @Override
    @Nullable
    public VectorCursor asVectorCursor() {
        CursorResources resources = (CursorResources)this.resourcesSupplier.get();
        FilterBundle filterBundle = resources.filterBundle;
        long minDataTimestamp = resources.minDataTimestamp;
        long maxDataTimestamp = resources.maxDataTimestamp;
        NumericColumn timestamps = resources.timestamps;
        ColumnCache columnCache = resources.columnCache;
        Order timeOrder = resources.timeOrder;
        if (!this.canVectorize()) {
            this.close();
            throw new IllegalStateException("canVectorize()");
        }
        if (this.metrics != null) {
            this.metrics.vectorized(true);
        }
        int startOffset = timeOrder != Order.NONE && this.interval.getStartMillis() > minDataTimestamp ? QueryableIndexCursorHolder.timeSearch(timestamps, this.interval.getStartMillis(), 0, this.index.getNumRows()) : 0;
        int endOffset = timeOrder != Order.NONE && this.interval.getEndMillis() <= maxDataTimestamp ? QueryableIndexCursorHolder.timeSearch(timestamps, this.interval.getEndMillis(), startOffset, this.index.getNumRows()) : this.index.getNumRows();
        VectorOffset baseOffset = filterBundle == null || filterBundle.getIndex() == null ? new NoFilterVectorOffset(this.vectorSize, startOffset, endOffset) : new BitmapVectorOffset(this.vectorSize, filterBundle.getIndex().getBitmap(), startOffset, endOffset);
        VectorColumnSelectorFactory baseColumnSelectorFactory = this.makeVectorColumnSelectorFactoryForOffset(columnCache, baseOffset);
        if (filterBundle != null && filterBundle.getMatcherBundle() != null) {
            VectorValueMatcher vectorValueMatcher = filterBundle.getMatcherBundle().vectorMatcher(baseColumnSelectorFactory, baseOffset);
            FilteredVectorOffset filteredOffset = FilteredVectorOffset.create(baseOffset, vectorValueMatcher);
            VectorColumnSelectorFactory filteredColumnSelectorFactory = this.makeVectorColumnSelectorFactoryForOffset(columnCache, filteredOffset);
            return new QueryableIndexVectorCursor(filteredColumnSelectorFactory, filteredOffset, this.vectorSize);
        }
        return new QueryableIndexVectorCursor(baseColumnSelectorFactory, baseOffset, this.vectorSize);
    }

    @Override
    public List<OrderBy> getOrdering() {
        return this.ordering;
    }

    @Override
    public void close() {
        CloseableUtils.closeAndWrapExceptions((Closeable)this.resourcesSupplier.get());
    }

    protected ColumnSelectorFactory makeColumnSelectorFactoryForOffset(ColumnCache columnCache, Offset baseOffset) {
        return new QueryableIndexColumnSelectorFactory(this.virtualColumns, Cursors.getTimeOrdering(this.ordering), baseOffset.getBaseReadableOffset(), columnCache);
    }

    protected VectorColumnSelectorFactory makeVectorColumnSelectorFactoryForOffset(ColumnCache columnCache, VectorOffset baseOffset) {
        return new QueryableIndexVectorColumnSelectorFactory(this.index, baseOffset, columnCache, this.virtualColumns);
    }

    @VisibleForTesting
    static int timeSearch(NumericColumn timeColumn, long timestamp, int startIndex, int endIndex) {
        long prevTimestamp = timestamp - 1L;
        int minIndex = startIndex;
        int maxIndex = endIndex - 1;
        while (minIndex <= maxIndex) {
            int currIndex = minIndex + maxIndex >>> 1;
            long currValue = timeColumn.getLongSingleValueRow(currIndex);
            if (currValue < prevTimestamp) {
                minIndex = currIndex + 1;
                continue;
            }
            if (currValue > prevTimestamp) {
                maxIndex = currIndex - 1;
                continue;
            }
            minIndex = currIndex;
            break;
        }
        while (minIndex < endIndex) {
            long currValue = timeColumn.getLongSingleValueRow(minIndex);
            if (currValue >= timestamp) {
                return minIndex;
            }
            ++minIndex;
        }
        return endIndex;
    }

    @Nullable
    private static FilterBundle makeFilterBundle(@Nullable Filter filter, boolean cursorAutoArrangeFilters, ColumnSelectorColumnIndexSelector bitmapIndexSelector, int numRows, @Nullable QueryMetrics<?> metrics) {
        DefaultBitmapResultFactory bitmapResultFactory;
        BitmapFactory bitmapFactory = bitmapIndexSelector.getBitmapFactory();
        if (metrics != null) {
            bitmapResultFactory = metrics.makeBitmapResultFactory(bitmapFactory);
            metrics.reportSegmentRows(numRows);
        } else {
            bitmapResultFactory = new DefaultBitmapResultFactory(bitmapFactory);
        }
        if (filter == null) {
            return null;
        }
        long bitmapConstructionStartNs = System.nanoTime();
        FilterBundle filterBundle = new FilterBundle.Builder(filter, bitmapIndexSelector, cursorAutoArrangeFilters).build(bitmapResultFactory, numRows, numRows, false);
        if (metrics != null) {
            long buildTime = System.nanoTime() - bitmapConstructionStartNs;
            metrics.reportBitmapConstructionTime(buildTime);
            FilterBundle.BundleInfo info = filterBundle.getInfo();
            metrics.filterBundle(info);
            log.debug("Filter partitioning (%sms):%s", TimeUnit.NANOSECONDS.toMillis(buildTime), info);
            if (filterBundle.getIndex() != null) {
                metrics.reportPreFilteredRows(filterBundle.getIndex().getBitmap().size());
            } else {
                metrics.reportPreFilteredRows(0L);
            }
        } else if (log.isDebugEnabled()) {
            FilterBundle.BundleInfo info = filterBundle.getInfo();
            long buildTime = System.nanoTime() - bitmapConstructionStartNs;
            log.debug("Filter partitioning (%sms):%s", TimeUnit.NANOSECONDS.toMillis(buildTime), info);
        }
        return filterBundle;
    }

    @Nullable
    private static Filter computeFilterWithIntervalIfNeeded(Order timeOrder, long minDataTimestamp, long maxDataTimestamp, Interval interval, @Nullable Filter filter) {
        if (timeOrder == Order.NONE && (minDataTimestamp < interval.getStartMillis() || maxDataTimestamp >= interval.getEndMillis())) {
            RangeFilter timeFilter = new RangeFilter("__time", ColumnType.LONG, minDataTimestamp < interval.getStartMillis() ? Long.valueOf(interval.getStartMillis()) : null, maxDataTimestamp >= interval.getEndMillis() ? Long.valueOf(interval.getEndMillis()) : null, false, true, null);
            if (filter == null) {
                return timeFilter;
            }
            return new AndFilter((List<Filter>)ImmutableList.of((Object)filter, (Object)timeFilter));
        }
        return filter;
    }

    private static final class CursorResources
    implements Closeable {
        private final Closer closer = Closer.create();
        private final long minDataTimestamp;
        private final long maxDataTimestamp;
        private final int numRows;
        @Nullable
        private final FilterBundle filterBundle;
        private final NumericColumn timestamps;
        private final Order timeOrder;
        private final ColumnCache columnCache;

        private CursorResources(QueryableIndex index, VirtualColumns virtualColumns, Order timeOrder, Interval interval, @Nullable Filter filter, boolean cursorAutoArrangeFilters, @Nullable QueryMetrics<? extends Query<?>> metrics) {
            this.columnCache = new ColumnCache(index, this.closer);
            ColumnSelectorColumnIndexSelector bitmapIndexSelector = new ColumnSelectorColumnIndexSelector(index.getBitmapFactoryForDimensions(), virtualColumns, this.columnCache);
            try {
                this.numRows = index.getNumRows();
                this.timestamps = (NumericColumn)this.columnCache.getColumn("__time");
                this.minDataTimestamp = DateTimes.utc(this.timestamps.getLongSingleValueRow(0)).getMillis();
                this.maxDataTimestamp = DateTimes.utc(this.timestamps.getLongSingleValueRow(this.timestamps.length() - 1)).getMillis();
                this.filterBundle = QueryableIndexCursorHolder.makeFilterBundle(QueryableIndexCursorHolder.computeFilterWithIntervalIfNeeded(timeOrder, this.minDataTimestamp, this.maxDataTimestamp, interval, filter), cursorAutoArrangeFilters, bitmapIndexSelector, this.numRows, metrics);
                this.timeOrder = timeOrder;
            }
            catch (Throwable t) {
                throw CloseableUtils.closeAndWrapInCatch(t, this.closer);
            }
        }

        @Override
        public void close() throws IOException {
            this.closer.close();
        }
    }

    public static class DescendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        DescendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current >= this.timeLimit;
        }

        public String toString() {
            return this.timeLimit + ">=" + (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new DescendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static class AscendingTimestampCheckingOffset
    extends TimestampCheckingOffset {
        AscendingTimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            super(baseOffset, timestamps, timeLimit, allWithinThreshold);
        }

        @Override
        protected final boolean timeInRange(long current) {
            return current < this.timeLimit;
        }

        public String toString() {
            return (this.baseOffset.withinBounds() ? Long.valueOf(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset())) : "OOB") + "<" + this.timeLimit + "::" + this.baseOffset;
        }

        @Override
        public Offset clone() {
            return new AscendingTimestampCheckingOffset(this.baseOffset.clone(), this.timestamps, this.timeLimit, this.allWithinThreshold);
        }
    }

    public static abstract class TimestampCheckingOffset
    extends Offset {
        final Offset baseOffset;
        final NumericColumn timestamps;
        final long timeLimit;
        final boolean allWithinThreshold;

        TimestampCheckingOffset(Offset baseOffset, NumericColumn timestamps, long timeLimit, boolean allWithinThreshold) {
            this.baseOffset = baseOffset;
            this.timestamps = timestamps;
            this.timeLimit = timeLimit;
            this.allWithinThreshold = allWithinThreshold;
        }

        @Override
        public int getOffset() {
            return this.baseOffset.getOffset();
        }

        @Override
        public boolean withinBounds() {
            if (!this.baseOffset.withinBounds()) {
                return false;
            }
            if (this.allWithinThreshold) {
                return true;
            }
            return this.timeInRange(this.timestamps.getLongSingleValueRow(this.baseOffset.getOffset()));
        }

        @Override
        public void reset() {
            this.baseOffset.reset();
        }

        @Override
        public ReadableOffset getBaseReadableOffset() {
            return this.baseOffset.getBaseReadableOffset();
        }

        protected abstract boolean timeInRange(long var1);

        @Override
        public void increment() {
            this.baseOffset.increment();
        }

        @Override
        public Offset clone() {
            throw new IllegalStateException("clone");
        }

        @Override
        public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
            inspector.visit("baseOffset", this.baseOffset);
            inspector.visit("timestamps", this.timestamps);
            inspector.visit("allWithinThreshold", this.allWithinThreshold);
        }
    }

    private static class QueryableIndexCursor
    implements HistoricalCursor {
        private final Offset cursorOffset;
        private final ColumnSelectorFactory columnSelectorFactory;

        QueryableIndexCursor(Offset cursorOffset, ColumnSelectorFactory columnSelectorFactory) {
            this.cursorOffset = cursorOffset;
            this.columnSelectorFactory = columnSelectorFactory;
        }

        @Override
        public Offset getOffset() {
            return this.cursorOffset;
        }

        @Override
        public ColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public void advance() {
            this.cursorOffset.increment();
            BaseQuery.checkInterrupted();
        }

        @Override
        public void advanceUninterruptibly() {
            this.cursorOffset.increment();
        }

        @Override
        public boolean isDone() {
            return !this.cursorOffset.withinBounds();
        }

        @Override
        public boolean isDoneOrInterrupted() {
            return this.isDone() || Thread.currentThread().isInterrupted();
        }

        @Override
        public void reset() {
            this.cursorOffset.reset();
        }
    }

    private static class QueryableIndexVectorCursor
    implements VectorCursor {
        private final int vectorSize;
        private final VectorOffset offset;
        private final VectorColumnSelectorFactory columnSelectorFactory;

        public QueryableIndexVectorCursor(VectorColumnSelectorFactory vectorColumnSelectorFactory, VectorOffset offset, int vectorSize) {
            this.columnSelectorFactory = vectorColumnSelectorFactory;
            this.vectorSize = vectorSize;
            this.offset = offset;
        }

        @Override
        public int getMaxVectorSize() {
            return this.vectorSize;
        }

        @Override
        public int getCurrentVectorSize() {
            return this.offset.getCurrentVectorSize();
        }

        @Override
        public VectorColumnSelectorFactory getColumnSelectorFactory() {
            return this.columnSelectorFactory;
        }

        @Override
        public void advance() {
            this.offset.advance();
            BaseQuery.checkInterrupted();
        }

        @Override
        public boolean isDone() {
            return this.offset.isDone();
        }

        @Override
        public void reset() {
            this.offset.reset();
        }
    }
}

