/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.PeekingIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.collections.bitmap.BitmapFactory;
import org.apache.druid.collections.bitmap.MutableBitmap;
import org.apache.druid.collections.spatial.ImmutableRTree;
import org.apache.druid.collections.spatial.RTree;
import org.apache.druid.collections.spatial.split.LinearGutmanSplitStrategy;
import org.apache.druid.common.config.NullHandling;
import org.apache.druid.error.DruidException;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.segment.DictionaryEncodedColumnMerger;
import org.apache.druid.segment.DictionaryMergingIterator;
import org.apache.druid.segment.DimensionMergerV9;
import org.apache.druid.segment.IndexIO;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.IndexableAdapter;
import org.apache.druid.segment.ProgressIndicator;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnDescriptor;
import org.apache.druid.segment.column.StringEncodingStrategies;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.BitmapSerdeFactory;
import org.apache.druid.segment.data.ByteBufferWriter;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.data.DictionaryWriter;
import org.apache.druid.segment.data.GenericIndexed;
import org.apache.druid.segment.data.ImmutableRTreeObjectStrategy;
import org.apache.druid.segment.data.Indexed;
import org.apache.druid.segment.data.ListIndexed;
import org.apache.druid.segment.data.ObjectStrategy;
import org.apache.druid.segment.serde.DictionaryEncodedColumnPartSerde;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class StringDimensionMergerV9
extends DictionaryEncodedColumnMerger<String> {
    private static final Indexed<String> NULL_STR_DIM_VAL = new ListIndexed<Object>(Collections.singletonList(null));
    private static final Splitter SPLITTER = Splitter.on((String)",");
    public static final Comparator<Pair<Integer, PeekingIterator<String>>> DICTIONARY_MERGING_COMPARATOR = DictionaryMergingIterator.makePeekingComparator();
    @Nullable
    private ByteBufferWriter<ImmutableRTree> spatialWriter;

    public StringDimensionMergerV9(String dimensionName, String outputName, IndexSpec indexSpec, SegmentWriteOutMedium segmentWriteOutMedium, ColumnCapabilities capabilities, ProgressIndicator progress, Closer closer) {
        super(dimensionName, outputName, indexSpec, segmentWriteOutMedium, capabilities, progress, closer);
    }

    @Override
    protected Comparator<Pair<Integer, PeekingIterator<String>>> getDictionaryMergingComparator() {
        return DICTIONARY_MERGING_COMPARATOR;
    }

    @Override
    protected Indexed<String> getNullDimValue() {
        return NULL_STR_DIM_VAL;
    }

    @Override
    protected ObjectStrategy<String> getObjectStrategy() {
        return GenericIndexed.STRING_STRATEGY;
    }

    @Override
    protected String coerceValue(String value) {
        return NullHandling.emptyToNullIfNeeded(value);
    }

    @Override
    protected DictionaryWriter<String> makeDictionaryWriter(String fileName) {
        return StringEncodingStrategies.getStringDictionaryWriter(this.indexSpec.getStringDictionaryEncoding(), this.segmentWriteOutMedium, fileName);
    }

    @Override
    @Nullable
    protected DictionaryEncodedColumnMerger.ExtendedIndexesMerger getExtendedIndexesMerger() {
        if (this.capabilities.hasSpatialIndexes()) {
            return new SpatialIndexesMerger();
        }
        return null;
    }

    @Override
    public ColumnDescriptor makeColumnDescriptor() {
        boolean hasMultiValue = this.capabilities.hasMultipleValues().isTrue();
        CompressionStrategy compressionStrategy = this.indexSpec.getDimensionCompression();
        BitmapSerdeFactory bitmapSerdeFactory = this.indexSpec.getBitmapSerdeFactory();
        ColumnDescriptor.Builder builder = ColumnDescriptor.builder();
        builder.setValueType(ValueType.STRING);
        builder.setHasMultipleValues(hasMultiValue);
        DictionaryEncodedColumnPartSerde.SerializerBuilder partBuilder = DictionaryEncodedColumnPartSerde.serializerBuilder().withValue(this.encodedValueSerializer, hasMultiValue, compressionStrategy != CompressionStrategy.UNCOMPRESSED).withBitmapSerdeFactory(bitmapSerdeFactory).withBitmapIndex(this.bitmapWriter).withSpatialIndex(this.spatialWriter).withByteOrder(IndexIO.BYTE_ORDER);
        if (this.writeDictionary) {
            partBuilder = partBuilder.withDictionary(this.dictionaryWriter);
        }
        return builder.addSerde(partBuilder.build()).build();
    }

    @Override
    public void attachParent(DimensionMergerV9 parent, List<IndexableAdapter> projectionAdapters) throws IOException {
        DruidException.conditionalDefensive(parent instanceof StringDimensionMergerV9, "Projection parent column must be same type, got [%s]", parent.getClass());
        StringDimensionMergerV9 stringParent = (StringDimensionMergerV9)parent;
        this.dictionarySize = stringParent.dictionarySize;
        this.dimConversions = stringParent.dimConversions;
        this.dictionaryWriter = stringParent.dictionaryWriter;
        this.cardinality = this.dictionaryWriter.getCardinality();
        this.adapters = projectionAdapters;
        this.setupEncodedValueWriter();
        this.writeDictionary = false;
    }

    public class SpatialIndexesMerger
    implements DictionaryEncodedColumnMerger.ExtendedIndexesMerger {
        private RTree tree;
        private final boolean hasSpatial;

        public SpatialIndexesMerger() {
            this.hasSpatial = StringDimensionMergerV9.this.capabilities.hasSpatialIndexes();
        }

        @Override
        public void initialize() throws IOException {
            BitmapFactory bitmapFactory = StringDimensionMergerV9.this.indexSpec.getBitmapSerdeFactory().getBitmapFactory();
            if (this.hasSpatial) {
                StringDimensionMergerV9.this.spatialWriter = new ByteBufferWriter<ImmutableRTree>(StringDimensionMergerV9.this.segmentWriteOutMedium, new ImmutableRTreeObjectStrategy(bitmapFactory));
                StringDimensionMergerV9.this.spatialWriter.open();
                this.tree = new RTree(2, new LinearGutmanSplitStrategy(0, 50, bitmapFactory), bitmapFactory);
            }
        }

        @Override
        public void mergeIndexes(int dictId, MutableBitmap mergedIndexes) throws IOException {
            String dimVal;
            if (this.hasSpatial && (dimVal = (String)StringDimensionMergerV9.this.dictionaryWriter.get(dictId)) != null) {
                ArrayList stringCoords = Lists.newArrayList((Iterable)SPLITTER.split((CharSequence)dimVal));
                float[] coords = new float[stringCoords.size()];
                for (int j = 0; j < coords.length; ++j) {
                    coords[j] = Float.valueOf((String)stringCoords.get(j)).floatValue();
                }
                this.tree.insert(coords, mergedIndexes);
            }
        }

        @Override
        public void write() throws IOException {
            if (this.hasSpatial) {
                StringDimensionMergerV9.this.spatialWriter.write(ImmutableRTree.newImmutableFromMutable(this.tree));
            }
        }
    }
}

