/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.incremental;

import javax.annotation.Nullable;
import org.apache.druid.query.Order;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionIndexer;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.RowIdSupplier;
import org.apache.druid.segment.SingleScanTimeDimensionSelector;
import org.apache.druid.segment.VirtualColumns;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.column.ValueTypes;
import org.apache.druid.segment.incremental.IncrementalIndex;
import org.apache.druid.segment.incremental.IncrementalIndexCursorFactory;
import org.apache.druid.segment.incremental.IncrementalIndexRowHolder;
import org.apache.druid.segment.incremental.IncrementalIndexRowSelector;

class IncrementalIndexColumnSelectorFactory
implements ColumnSelectorFactory,
RowIdSupplier {
    private final ColumnInspector snapshotColumnInspector;
    private final VirtualColumns virtualColumns;
    private final Order timeOrder;
    private final IncrementalIndexRowHolder rowHolder;
    private final IncrementalIndexRowSelector rowSelector;

    IncrementalIndexColumnSelectorFactory(final IncrementalIndexRowSelector rowSelector, IncrementalIndexRowHolder rowHolder, VirtualColumns virtualColumns, Order timeOrder) {
        this.rowSelector = rowSelector;
        this.virtualColumns = virtualColumns;
        this.timeOrder = timeOrder;
        this.rowHolder = rowHolder;
        this.snapshotColumnInspector = new ColumnInspector(){

            @Override
            @Nullable
            public ColumnCapabilities getColumnCapabilities(String column) {
                return IncrementalIndexCursorFactory.snapshotColumnCapabilities(rowSelector, column);
            }
        };
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec) {
        if (this.virtualColumns.exists(dimensionSpec.getDimension())) {
            return this.virtualColumns.makeDimensionSelector(dimensionSpec, this);
        }
        return dimensionSpec.decorate(this.makeDimensionSelectorUndecorated(dimensionSpec));
    }

    private DimensionSelector makeDimensionSelectorUndecorated(DimensionSpec dimensionSpec) {
        String dimension = dimensionSpec.getDimension();
        ExtractionFn extractionFn = dimensionSpec.getExtractionFn();
        if (this.isTimeColumn(dimension) && this.timeOrder != Order.NONE) {
            return new SingleScanTimeDimensionSelector(this.makeColumnValueSelector(dimension), extractionFn, this.timeOrder);
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.rowSelector.getDimension(dimensionSpec.getDimension());
        if (dimensionDesc == null) {
            ColumnCapabilities capabilities = this.getColumnCapabilities(dimension);
            if (capabilities == null) {
                return DimensionSelector.constant(null, extractionFn);
            }
            if (capabilities.isNumeric()) {
                return ValueTypes.makeNumericWrappingDimensionSelector((ValueType)capabilities.getType(), this.makeColumnValueSelector(dimension), extractionFn);
            }
            return DimensionSelector.constant(null, extractionFn);
        }
        DimensionIndexer<?, ?, ?> indexer = dimensionDesc.getIndexer();
        return indexer.makeDimensionSelector(dimensionSpec, this.rowHolder, dimensionDesc);
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName) {
        if (this.virtualColumns.exists(columnName)) {
            return this.virtualColumns.makeColumnValueSelector(columnName, this);
        }
        if (this.isTimeColumn(columnName)) {
            return this.rowHolder;
        }
        IncrementalIndex.DimensionDesc dimensionDesc = this.rowSelector.getDimension(columnName);
        if (dimensionDesc != null) {
            DimensionIndexer<?, ?, ?> indexer = dimensionDesc.getIndexer();
            return indexer.makeColumnValueSelector(this.rowHolder, dimensionDesc);
        }
        return IncrementalIndex.makeMetricColumnValueSelector(this.rowSelector, this.rowHolder, columnName);
    }

    @Override
    @Nullable
    public ColumnCapabilities getColumnCapabilities(String columnName) {
        if (this.isTimeColumn(columnName)) {
            return this.virtualColumns.getColumnCapabilitiesWithFallback(this.snapshotColumnInspector, "__time");
        }
        return this.virtualColumns.getColumnCapabilitiesWithFallback(this.snapshotColumnInspector, columnName);
    }

    @Override
    @Nullable
    public RowIdSupplier getRowIdSupplier() {
        return this;
    }

    @Override
    public long getRowId() {
        return this.rowHolder.get().getRowIndex();
    }

    private boolean isTimeColumn(String columnName) {
        return "__time".equals(columnName);
    }
}

