/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.index;

import javax.annotation.Nullable;
import org.apache.druid.query.BitmapResultFactory;
import org.apache.druid.segment.index.SimpleImmutableBitmapIterableIndex;

public abstract class DictionaryScanningBitmapIndex
extends SimpleImmutableBitmapIterableIndex {
    private final int dictionarySize;
    private final double scaleThreshold;

    public DictionaryScanningBitmapIndex(int dictionarySize) {
        this(dictionarySize, 1.0);
    }

    public DictionaryScanningBitmapIndex(int dictionarySize, double scaleThreshold) {
        this.dictionarySize = dictionarySize;
        this.scaleThreshold = scaleThreshold;
    }

    @Override
    public int estimatedComputeCost() {
        return this.dictionarySize;
    }

    @Override
    @Nullable
    public final <T> T computeBitmapResult(BitmapResultFactory<T> bitmapResultFactory, int applyRowCount, int totalRowCount, boolean includeUnknown) {
        if (applyRowCount != totalRowCount && (double)applyRowCount < (double)this.dictionarySize * this.scaleThreshold) {
            return null;
        }
        return bitmapResultFactory.unionDimensionValueBitmaps(this.getBitmapIterable(includeUnknown));
    }
}

