/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.join;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.SetMultimap;
import com.google.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.DataSource;
import org.apache.druid.segment.join.JoinConditionAnalysis;
import org.apache.druid.segment.join.Joinable;
import org.apache.druid.segment.join.JoinableFactory;

public class MapJoinableFactory
implements JoinableFactory {
    private final SetMultimap<Class<? extends DataSource>, JoinableFactory> joinableFactories = HashMultimap.create();

    @Inject
    public MapJoinableFactory(Set<JoinableFactory> factories, Map<Class<? extends JoinableFactory>, Class<? extends DataSource>> factoryToDataSource) {
        factories.forEach(joinableFactory -> this.joinableFactories.put(factoryToDataSource.get(joinableFactory.getClass()), joinableFactory));
    }

    @Override
    public boolean isDirectlyJoinable(DataSource dataSource) {
        Set factories = this.joinableFactories.get(dataSource.getClass());
        for (JoinableFactory factory : factories) {
            if (!factory.isDirectlyJoinable(dataSource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Optional<Joinable> build(DataSource dataSource, JoinConditionAnalysis condition) {
        return this.getSingleResult(dataSource, factory -> factory.build(dataSource, condition));
    }

    @Override
    public Optional<byte[]> computeJoinCacheKey(DataSource dataSource, JoinConditionAnalysis condition) {
        return this.getSingleResult(dataSource, factory -> factory.computeJoinCacheKey(dataSource, condition));
    }

    private <T> Optional<T> getSingleResult(DataSource dataSource, Function<JoinableFactory, Optional<T>> function) {
        Set factories = this.joinableFactories.get(dataSource.getClass());
        Optional mayBeFinalResult = Optional.empty();
        for (JoinableFactory joinableFactory : factories) {
            Optional<T> candidate = function.apply(joinableFactory);
            if (candidate.isPresent() && mayBeFinalResult.isPresent()) {
                throw new ISE("Multiple joinable factories are valid for table[%s]", dataSource);
            }
            if (!candidate.isPresent()) continue;
            mayBeFinalResult = candidate;
        }
        return mayBeFinalResult;
    }
}

