/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.nested;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.segment.nested.NestedPathPart;

public class NestedPathArrayElement
implements NestedPathPart {
    private final int index;

    @JsonCreator
    public NestedPathArrayElement(@JsonProperty(value="index") int index) {
        this.index = index;
    }

    @Override
    @Nullable
    public Object find(@Nullable Object input) {
        if (input instanceof List) {
            List currentList = (List)input;
            int currentSize = currentList.size();
            if (this.index < 0) {
                int adjusted = currentSize + this.index;
                if (adjusted >= 0) {
                    return currentList.get(adjusted);
                }
            } else if (currentList.size() > this.index) {
                return currentList.get(this.index);
            }
        } else if (input instanceof Object[]) {
            Object[] currentList = (Object[])input;
            if (this.index < 0) {
                int adjusted = currentList.length + this.index;
                if (adjusted >= 0) {
                    return currentList[adjusted];
                }
            } else if (currentList.length > this.index) {
                return currentList[this.index];
            }
        }
        return null;
    }

    @Override
    public String getPartIdentifier() {
        return String.valueOf(this.index);
    }

    @JsonProperty(value="index")
    public int getIndex() {
        return this.index;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NestedPathArrayElement that = (NestedPathArrayElement)o;
        return this.index == that.index;
    }

    public int hashCode() {
        return Objects.hash(this.index);
    }

    public String toString() {
        return "NestedPathArrayElement{index=" + this.index + '}';
    }
}

