/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.query.monomorphicprocessing.RuntimeShapeInspector;
import org.apache.druid.segment.data.Indexed;

public class ReplaceFirstValueWithNullIndexed<T>
implements Indexed<T> {
    private final Indexed<T> delegate;

    public ReplaceFirstValueWithNullIndexed(Indexed<T> delegate) {
        this.delegate = delegate;
        if (delegate.size() < 1) {
            throw new ISE("Size[%s] must be >= 1", delegate.size());
        }
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    @Nullable
    public T get(int index) {
        if (index == 0) {
            return null;
        }
        return this.delegate.get(index);
    }

    @Override
    public int indexOf(@Nullable T value) {
        if (value == null) {
            return 0;
        }
        int result = this.delegate.indexOf(value);
        if (result == 0 || result == -1) {
            return -2;
        }
        return result;
    }

    @Override
    public boolean isSorted() {
        return this.delegate.isSorted();
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator it = this.delegate.iterator();
        it.next();
        class ReplaceFirstValueWithNullIndexedIterator
        implements Iterator<T> {
            boolean returnedNull;

            ReplaceFirstValueWithNullIndexedIterator() {
            }

            @Override
            public boolean hasNext() {
                return !this.returnedNull || it.hasNext();
            }

            @Override
            public T next() {
                if (!this.returnedNull) {
                    this.returnedNull = true;
                    return null;
                }
                return it.next();
            }
        }
        return new ReplaceFirstValueWithNullIndexedIterator();
    }

    @Override
    public void inspectRuntimeShape(RuntimeShapeInspector inspector) {
        this.delegate.inspectRuntimeShape(inspector);
    }
}

