/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.serde.cell;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.io.smoosh.FileSmoosher;
import org.apache.druid.segment.data.CompressionStrategy;
import org.apache.druid.segment.serde.Serializer;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadBuffer;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadBufferFactory;
import org.apache.druid.segment.serde.cell.BlockCompressedPayloadSerializer;
import org.apache.druid.segment.serde.cell.ByteBufferProvider;
import org.apache.druid.segment.serde.cell.NativeClearedByteBufferProvider;
import org.apache.druid.segment.writeout.SegmentWriteOutMedium;

public class BlockCompressedPayloadWriter
implements Serializer,
Closeable {
    private final BlockCompressedPayloadBuffer buffer;
    private BlockCompressedPayloadSerializer serializer;
    private State state = State.OPEN;

    private BlockCompressedPayloadWriter(BlockCompressedPayloadBuffer buffer) {
        this.buffer = buffer;
    }

    public void write(byte[] payload) throws IOException {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0);
        this.buffer.write(payload);
    }

    public void write(ByteBuffer payload) throws IOException {
        Preconditions.checkState((this.state == State.OPEN ? 1 : 0) != 0);
        this.buffer.write(payload);
    }

    @Override
    public void close() throws IOException {
        if (this.state == State.OPEN) {
            this.serializer = this.buffer.closeToSerializer();
            this.state = State.CLOSED;
        }
    }

    @Override
    public void writeTo(WritableByteChannel channel, @Nullable FileSmoosher smoosher) throws IOException {
        Preconditions.checkState((this.state == State.CLOSED ? 1 : 0) != 0);
        this.serializer.writeTo(channel, smoosher);
    }

    @Override
    public long getSerializedSize() {
        Preconditions.checkState((this.state == State.CLOSED ? 1 : 0) != 0);
        return this.serializer.getSerializedSize();
    }

    public static class Builder {
        private ByteBufferProvider byteBufferProvider = NativeClearedByteBufferProvider.INSTANCE;
        private final SegmentWriteOutMedium writeOutMedium;
        private CompressionStrategy compressionStrategy = CompressionStrategy.LZ4;

        public Builder(SegmentWriteOutMedium writeOutMedium) {
            this.writeOutMedium = writeOutMedium;
        }

        public Builder setCompressionStrategy(CompressionStrategy compressionStrategy) {
            this.compressionStrategy = compressionStrategy;
            return this;
        }

        public Builder setByteBufferProvider(ByteBufferProvider byteBufferProvider) {
            this.byteBufferProvider = byteBufferProvider;
            return this;
        }

        public BlockCompressedPayloadWriter build() throws IOException {
            BlockCompressedPayloadBufferFactory bufferFactory = new BlockCompressedPayloadBufferFactory(this.byteBufferProvider, this.writeOutMedium, this.compressionStrategy.getCompressor());
            BlockCompressedPayloadBuffer payloadBuffer = bufferFactory.create();
            BlockCompressedPayloadWriter payloadWriter = new BlockCompressedPayloadWriter(payloadBuffer);
            return payloadWriter;
        }
    }

    private static enum State {
        OPEN,
        CLOSED;

    }
}

