/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.virtual;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.cache.CacheKeyBuilder;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.query.filter.ColumnIndexSelector;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnCapabilitiesImpl;
import org.apache.druid.segment.column.ColumnHolder;
import org.apache.druid.segment.column.ColumnIndexSupplier;
import org.apache.druid.segment.vector.MultiValueDimensionVectorSelector;
import org.apache.druid.segment.vector.SingleValueDimensionVectorSelector;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;
import org.apache.druid.segment.vector.VectorObjectSelector;
import org.apache.druid.segment.vector.VectorValueSelector;

public class FallbackVirtualColumn
implements VirtualColumn {
    private final String name;
    private final ArrayList<DimensionSpec> columns;

    @JsonCreator
    public FallbackVirtualColumn(@JsonProperty(value="name") String name, @JsonProperty(value="columns") ArrayList<DimensionSpec> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new IAE("Cannot have a null/empty columns[%s], name[%s]", columns, name);
        }
        this.name = name;
        this.columns = columns;
    }

    @Override
    @JsonProperty(value="name")
    public String getOutputName() {
        return this.name;
    }

    @JsonProperty(value="columns")
    public ArrayList<DimensionSpec> getColumns() {
        return this.columns;
    }

    @Override
    public byte[] getCacheKey() {
        CacheKeyBuilder bob = new CacheKeyBuilder(3).appendString(this.name);
        for (DimensionSpec column : this.columns) {
            bob.appendCacheable(column);
        }
        return bob.build();
    }

    @Override
    public DimensionSelector makeDimensionSelector(DimensionSpec dimensionSpec, ColumnSelectorFactory factory) {
        return factory.makeDimensionSelector(this.columnToUse(factory));
    }

    @Override
    public ColumnValueSelector<?> makeColumnValueSelector(String columnName, ColumnSelectorFactory factory) {
        return factory.makeColumnValueSelector(this.columnToUse(factory).getDimension());
    }

    @Override
    public boolean canVectorize(ColumnInspector inspector) {
        return true;
    }

    @Override
    public SingleValueDimensionVectorSelector makeSingleValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        return factory.makeSingleValueDimensionSelector(this.columnToUse(factory));
    }

    @Override
    public MultiValueDimensionVectorSelector makeMultiValueVectorDimensionSelector(DimensionSpec dimensionSpec, VectorColumnSelectorFactory factory) {
        return factory.makeMultiValueDimensionSelector(this.columnToUse(factory));
    }

    @Override
    public VectorValueSelector makeVectorValueSelector(String columnName, VectorColumnSelectorFactory factory) {
        return factory.makeValueSelector(this.columnToUse(factory).getDimension());
    }

    @Override
    public VectorObjectSelector makeVectorObjectSelector(String columnName, VectorColumnSelectorFactory factory) {
        return factory.makeObjectSelector(this.columnToUse(factory).getDimension());
    }

    @Override
    public ColumnCapabilities capabilities(String columnName) {
        return ColumnCapabilitiesImpl.createDefault();
    }

    @Override
    @Nullable
    public ColumnCapabilities capabilities(ColumnInspector inspector, String columnName) {
        return (ColumnCapabilities)this.columnToUseInternal((ColumnInspector)inspector).rhs;
    }

    @Override
    public List<String> requiredColumns() {
        ArrayList<String> retVal = new ArrayList<String>(this.columns.size());
        for (DimensionSpec column : this.columns) {
            retVal.add(column.getDimension());
        }
        return retVal;
    }

    @Override
    public boolean usesDotNotation() {
        return false;
    }

    @Override
    @Nullable
    public ColumnIndexSupplier getIndexSupplier(String columnName, ColumnIndexSelector indexSelector) {
        ColumnHolder columnHolder = indexSelector.getColumnHolder(this.columnToUse(indexSelector).getDimension());
        if (columnHolder == null) {
            return null;
        }
        return columnHolder.getIndexSupplier();
    }

    private DimensionSpec columnToUse(ColumnInspector inspector) {
        return (DimensionSpec)this.columnToUseInternal((ColumnInspector)inspector).lhs;
    }

    @Nonnull
    private Pair<DimensionSpec, ColumnCapabilities> columnToUseInternal(ColumnInspector inspector) {
        Iterator<DimensionSpec> specs = this.columns.iterator();
        DimensionSpec firstSpec = specs.next();
        ColumnCapabilities firstCapabilities = inspector.getColumnCapabilities(firstSpec.getDimension());
        DimensionSpec spec = firstSpec;
        ColumnCapabilities capabilities = firstCapabilities;
        while (capabilities == null && specs.hasNext()) {
            spec = specs.next();
            capabilities = inspector.getColumnCapabilities(spec.getDimension());
        }
        if (capabilities == null) {
            return Pair.of(firstSpec, firstCapabilities);
        }
        return Pair.of(spec, capabilities);
    }
}

